package com.digiwin.athena.datamap.actions.adapters;

import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.actions.ErpAdapter;
import com.digiwin.athena.domain.erp.*;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-17 12:32
 **/

public abstract class AbstractErpAdapter implements ErpAdapter {

    private static final String ZH_TW = "zh_TW";
    private static final String EN_US = "en_US";
    private static final String ZH_CN = "zh_CN";

    @Override
    public ErpSyncRecord erpProject(Erp2DataDTO dto, List<ErpSyncRecord> records, Erp2FormInfo erp2FormInfo) throws DWBusinessException {
        Map<String, Object> current = fillMapByData(dto, erp2FormInfo);
        subFillData(dto, records, erp2FormInfo, current);

        List<ErpSyncRecord> records1 = new ArrayList<>();
        for (ErpSyncRecord record : records) {
            Map<String, Object> form = fillMapByForm(record, erp2FormInfo);
            int score = dataMatch(current, form);
            if (score < 1) {
                continue;
            }
            record.setScore(score);
            records1.add(record);
        }
        if (records1.size() > 0) {
            Collections.sort(records1, (r1, r2) -> r2.getScore() - r1.getScore());
            return records1.get(0);
        }
        return null;
    }

    protected abstract void subFillData(Erp2DataDTO dto, List<ErpSyncRecord> records, Erp2FormInfo erp2FormInfo, Map<String, Object> current) throws DWBusinessException;

    protected Map<String, Object> fillMapByData(Erp2DataDTO dto, Erp2FormInfo erp2FormInfo) {
        Map<String, Object> current = new HashMap<>();
        for (Erp2FormField field : erp2FormInfo.getFields()) {
            if (!Boolean.TRUE.equals(field.getAsUniKey())) {
                continue;
            }
            if (StringUtils.isEmpty(field.getPath())) {

                continue;
            }
            current.put(field.getKey(), getValue(dto.getData(), field.getPath()));
        }

        return current;
    }

    protected Map<String, Object> fillMapByForm(ErpSyncRecord record, Erp2FormInfo erp2FormInfo) {
        Map<String, Object> current = new HashMap<>();
        for (Erp2FormField field : erp2FormInfo.getFields()) {
            if (!Boolean.TRUE.equals(field.getAsUniKey())) {
                continue;
            }
            NameValue nameValue = record.getFormData().get(field.getKey());
            if (null != nameValue && null != nameValue.getValue()) {
                current.put(field.getKey(), nameValue.getValue());
            }
        }
        return current;
    }

    // 表单有的 报文有且必须相等
    protected int dataMatch(Map<String, Object> data, Map<String, Object> recordForm) {
        int count = 0;
        for (Map.Entry<String, Object> entry : recordForm.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (null == value) {
                continue;
            }
            if (value instanceof String) {
                String str = (String) value;
                if (StringUtils.isEmpty(str)) {
                    continue;
                }
            }
            Object value2 = data.get(key);
            if (value.equals(value2)) {
                count++;
            } else {
                return -1;
            }
        }

        return count;
    }

    protected Object getValue(Object root, String path) {
        return JSONPath.eval(root, path);
    }

    protected ErpSyncRecord dataMatch(List<Map<String, Object>> data, Map<String, Object> recordForm) {
        int num = 0;
        Map count = new HashMap();
        for (Map<String, Object> records : data) {
            for (Map.Entry<String, Object> entry : recordForm.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (null == value) {
                    continue;
                }
                if (value instanceof String) {
                    String str = (String) value;
                    if (StringUtils.isEmpty(str)) {
                        continue;
                    }
                }
                Object value2 = records.get(key);
                if (value.equals(value2)) {
                    num++;
                } else {
                    break;
                }
            }
            count.put(num, records);
        }

        Set<Integer> set = count.keySet();
        Object[] obj = set.toArray();
        Arrays.sort(obj);
        return (ErpSyncRecord) count.get(Integer.parseInt(obj[obj.length - 1].toString()));
    }

    protected void multilingualSettings(ErpSyncBill bill) {
        if (null == bill || bill.getProgram_name().isEmpty()) {
            return;
        }

        Map programName = bill.getProgram_name();
        programName.put(ZH_TW, bill.getProgram_name().get(ZH_TW.toLowerCase()));
        programName.put(EN_US, bill.getProgram_name().get(EN_US.toLowerCase()));
        programName.put(ZH_CN, bill.getProgram_name().get(ZH_CN.toLowerCase()));
        bill.setProgram_name(programName);
    }

}
