package com.digiwin.athena.datamap.actions.adapters;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.actions.ErpConstants;
import com.digiwin.athena.domain.erp.*;
import com.digiwin.athena.datamap.service.impl.DataMapActionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-17 12:33
 **/

@Service
public class E10Adapter extends AbstractErpAdapter {

    @Autowired
    DataMapActionService dataMapActionService;

    @Override
    public boolean support(String erp) {
        return ErpConstants.Erps.E10.equalsIgnoreCase(erp);
    }

    @Override
    public String erpTemplate(Erp2FormDTO dto) throws DWBusinessException {
        // String key = (String) dto.getData().get(ErpConstants.E10FormField.actionKey).getValue();
        // if(null==key){throw new DWBusinessException("未找到对应的action key");}
        // switch (key){
        // case ErpConstants.E10ActionType.Do:return ErpConstants.ErpTemplate.Do;
        // case ErpConstants.E10ActionType.unDo:return ErpConstants.ErpTemplate.unDo;
        // case ErpConstants.E10ActionType.DoCancel:return ErpConstants.ErpTemplate.DoCancel;
        // }
        // 当前统一使用一套模板
        return ErpConstants.ErpTemplate.Do;
    }

    @Override
    public ErpSyncBill getMeta(Erp2FormDTO dto) throws DWException {
        ActionReq req = new ActionReq();
        req.setActionId(ActionConstants.e10_oapi_schema_data_get);
        req.getParams().put(ErpConstants.E10FormField.program_id, dto.getData().get(ErpConstants.E10FormField.program_id).getValue());
        ActionResp actionResp = dataMapActionService.postProcess(req);
        ErpSyncBill bill = JSON.parseObject(JSON.toJSONString(actionResp.getData()), ErpSyncBill.class);
        multilingualSettings(bill);
        return bill;
    }

    @Override
    protected void subFillData(Erp2DataDTO dto, List<ErpSyncRecord> records, Erp2FormInfo erp2FormInfo, Map<String, Object> current) throws DWBusinessException {
        for (Erp2FormField field : erp2FormInfo.getFields()) {
            if (!Boolean.TRUE.equals(field.getAsUniKey())) {
                continue;
            }
            if (ErpConstants.E10FormField.op_org_no.equals(field.getKey())) {
                String orgType = (String) current.get(ErpConstants.E10FormField.source_doc_type);
                if (StringUtils.isEmpty(orgType)) {
                    return;
                }
                Object orgNo = null;
                switch (orgType) {
                    case ErpConstants.E10ComponentType.COMPANY:
                        orgNo = getValue(dto.getData(), "$.data." + ErpConstants.E10FormField.om_company_id);
                        break;
                    case ErpConstants.E10ComponentType.PLANT:
                        orgNo = getValue(dto.getData(), "$.data." + ErpConstants.E10FormField.om_site_id);
                        break;
                    case ErpConstants.E10ComponentType.SALES_CENTER:
                        orgNo = getValue(dto.getData(), "$.data." + ErpConstants.E10FormField.om_region_id);
                        break;
                    case ErpConstants.E10ComponentType.SUPPLY_CENTER:
                        orgNo = getValue(dto.getData(), "$.data." + ErpConstants.E10FormField.om_region_id);
                        break;
                    default:
                        break;
                }
                current.put(field.getKey(), orgNo);
            }
        }
    }

}
