package com.digiwin.athena.datamap.actions.handlers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.supports.EspBody;
import com.digiwin.athena.datamap.supports.EspRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * APC
 **/
@Service
@Order(10)
public class Esp_bm_dsc_wo_op_dispatch_get_for_connect extends AbstractActionHandler {

    @Override
    public String actionId() {
        // 不同的机制能力调用了同一个api，区分一下
        return ActionConstants.bm_dsc_wo_op_dispatch_get_connection_rule;
    }

    @Override
    public String description() {
        return "获取工单工艺派工信息";
    }

    @Override
    protected ActionResp callEsp(EspRequest request) {
        ActionResp resp = new ActionResp();
        EspBody body = espService.invokeSync(request);
        resp.setSuccess(body.getSuccess());
        if (body.getSuccess() && null != body.getStd_data() && null != body.getStd_data().getParameter()) {
            Map<String, Object> parameter = body.getStd_data().getParameter();
            Object wo_op_dispatch_data = parameter.get("wo_op_dispatch_data");
            if (ObjectUtils.isEmpty(wo_op_dispatch_data)) {
                resp.setData(new JSONArray[0]);
            } else {
                JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(wo_op_dispatch_data));
                Map<String, String> opNoDataMap = new HashMap<>();
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject responseJSON = jsonArray.getJSONObject(i);
                    if (responseJSON.containsKey("op_no") && !StringUtils.isEmpty(responseJSON.get("actual_start_date")) && !"2".equals(responseJSON.get("wo_property"))) {
                        opNoDataMap.put(responseJSON.getString("op_no"), responseJSON.getString("actual_start_date"));
                    }
                }
                resp.setData(opNoDataMap);
            }
        } else {
            resp.setMsg(body.getMsg());
            resp.setData(new JSONArray[0]);
            resp.setSuccess(Boolean.FALSE);
        }
        return resp;
    }

    @Override
    public ActionResp handler(ActionContext context) {
        EspRequest request = EspRequest.of(ActionConstants.bm_dsc_wo_op_dispatch_get,
                context.getActionReq().getProduct(), context.getActionReq().getParams(), super.E10headers());
        request.setHostProd("EAS");
        return callEsp(request);
    }

}
