package com.digiwin.athena.datamap.actions.handlers;

import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.actions.ErpConstants;
import com.digiwin.athena.datamap.supports.EspRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

/**
 获取元数据定义
 签核产品设计阶段获取E10集成对象，配置模板以及签核流程
 **/
@Service
@Order(10)
public class Esp_e10OapiSchemaDataGet extends AbstractActionHandler {

    @Override
    public String actionId() {
        return ActionConstants.e10_oapi_schema_data_get;
    }

    @Override
    public String description() {
        return " 获取元数据定义,签核产品设计阶段获取E10集成对象，配置模板以及签核流程,需要作业编号program_id";
    }

    @Override
    public ActionResp handler(ActionContext context) {

        EspRequest request = EspRequest.of(ActionConstants.e10_oapi_schema_data_get, ErpConstants.Erps.E10, context.getActionReq().getParams(), super.E10headers());
        request.setHostProd("EAS");
        return callEsp(request);

    }
}
