package com.digiwin.athena.datamap.actions.handlers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.actions.povo.EspCondition;
import com.digiwin.athena.datamap.supports.EspRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import com.digiwin.athena.datamap.actions.ErpConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-16 16:48
 **/
@Service
@Order(10)
public class Esp_e10_oapi_component_list_data_query_get extends AbstractActionHandler {

    @Override
    public String actionId() {
        return ActionConstants.e10_oapi_component_list_data_query_get;
    }

    @Override
    public String description() {
        return "根据组织类型获取组织列表，需要传入组织类型source_type_key";
    }

    @Override
    public ActionResp handler(ActionContext context) throws DWBusinessException {
        String doc_category = (String) context.getActionReq().getParams().get("source_type_key");
        if (null == doc_category) {
            throw new DWBusinessException("请传入组织类型");
        }
        Map<String, Object> params = new HashMap<>();
        params.put("page_size", 1000);
        params.put("page_no", 1);
        params.put("is_get_schema", false);
        params.put("is_get_count", false);
        params.put("conditions", new ArrayList<>());
        params.put("orders", new ArrayList<>());

        ActionResp resp = null;
        switch (doc_category) {
            case ErpConstants.E10ComponentType.COMPANY:
                EspRequest request1 = EspRequest.of(ActionConstants.e10_oapi_company_list_data_query_get, ErpConstants.Erps.E10, params, super.E10headers());
                request1.setHostProd("EAS");
                resp = callEsp(request1);
                addOptionProp(resp, "company_shortname", "om_company_id");
                break;
            case ErpConstants.E10ComponentType.PLANT:
                EspRequest request2 = EspRequest.of(ActionConstants.e10_oapi_plant_list_data_query_get, ErpConstants.Erps.E10, params, super.E10headers());
                request2.setHostProd("EAS");
                resp = callEsp(request2);
                addOptionProp(resp, "plant_name", "om_site_id");
                break;
            case ErpConstants.E10ComponentType.SALES_CENTER:
                params.put("conditions", EspCondition.ofList("approve_status", "=", "Y"));
                EspRequest request3 = EspRequest.of(ActionConstants.e10_oapi_sales_center_list_data_query_get, ErpConstants.Erps.E10, params, super.E10headers());
                request3.setHostProd("EAS");
                resp = callEsp(request3);
                addOptionProp(resp, "sales_center_name", "om_region_id");
                break;
            case ErpConstants.E10ComponentType.SUPPLY_CENTER:
                params.put("conditions", EspCondition.ofList("approve_status", "=", "Y"));
                EspRequest request4 = EspRequest.of(ActionConstants.e10_oapi_supply_center_list_data_query_get, ErpConstants.Erps.E10, params, super.E10headers());
                request4.setHostProd("EAS");
                resp = callEsp(request4);
                addOptionProp(resp, "supply_center_name", "om_region_id");
                break;
            default:
                break;
        }

        return resp;
    }

    private void addOptionProp(ActionResp resp, String name, String value) {
        if (resp.getSuccess() && null != resp.getData()) {
            Map data = (Map) resp.getData();
            List rows = (List) data.get("rows");
            if (null != rows) {
                for (Object item : rows) {
                    Map itemMap = (Map) item;
                    itemMap.put("name", itemMap.get(name));
                    itemMap.put("value", itemMap.get(value));
                }
            }
        }

    }
}
