package com.digiwin.athena.datamap.actions.handlers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.actions.ErpConstants;
import com.digiwin.athena.datamap.actions.povo.EspCondition;
import com.digiwin.athena.datamap.supports.EspRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-16 16:48
 **/
@Service
@Order(10)
public class Esp_e10_oapi_doc_list_data_query_get extends AbstractActionHandler {

    @Override
    public String actionId() {
        return ActionConstants.e10_oapi_doc_list_data_query_get;
    }

    @Override
    public String description() {
        return "用于获取单据类型，需要传入单据性质doc_category，";
    }

    @Override
    public ActionResp handler(ActionContext context) throws DWBusinessException {
        Object doc_category = context.getActionReq().getParams().get("doc_category");
        if (null == doc_category) {
            throw new DWBusinessException("请传入单据性质");
        }
        Map<String, Object> params = new HashMap<>();
        params.put("page_size", 1000);
        params.put("page_no", 1);
        params.put("is_get_schema", false);
        params.put("is_get_count", true);
        List<EspCondition> list = new ArrayList<>(2);
        list.add(EspCondition.of("approve_status", "=", "Y"));
        list.add(EspCondition.of("doc_category", "in", doc_category));
        params.put("conditions", list);
        params.put("orders", new ArrayList<>());

        EspRequest request = EspRequest.of(ActionConstants.e10_oapi_doc_list_data_query_get, ErpConstants.Erps.E10, params, super.E10headers());
        request.setHostProd("EAS");
        ActionResp resp = callEsp(request);

        return resp;
    }
}
