package com.digiwin.athena.datamap.actions.handlers;

import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.actions.ErpConstants;
import com.digiwin.athena.datamap.actions.povo.EspCondition;
import com.digiwin.athena.datamap.supports.EspRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-16 16:48
 **/
@Service
@Order(10)
public class Esp_e10_oapi_easyflow_object_list_data_query_get extends AbstractActionHandler {

    @Override
    public String actionId() {
        return ActionConstants.e10_oapi_easyflow_object_list_data_query_get;
    }

    @Override
    public String description() {
        return "用于获取单据列表";
    }

    @Override
    public ActionResp handler(ActionContext context) {
        Map<String, Object> params = new HashMap<>();
        params.put("page_size", 1000);
        params.put("page_no", 1);
        params.put("is_get_schema", false);
        params.put("is_get_count", true);
        params.put("conditions", EspCondition.ofList("erp_approve_suite_flag", "=", true));
        params.put("orders", new ArrayList<>());

        EspRequest request = EspRequest.of(ActionConstants.e10_oapi_easyflow_object_list_data_query_get, ErpConstants.Erps.E10, params, super.E10headers());
        request.setHostProd("EAS");
        ActionResp resp = callEsp(request);

        return resp;
    }
}
