package com.digiwin.athena.datamap.configuration;

import cn.hutool.core.util.ClassUtil;
import com.digiwin.athena.domain.common.TenantObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
//import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

import javax.annotation.PostConstruct;
import java.util.*;

/**
dap有块硬编码比较坑的设定
 如果不存在spring.datasource.url的设定会把DruidDataSourceAutoConfigure exclude掉，
 同理如果没有spring.rabbitmq.host的设定会把RabbitAutoConfiguration exclude掉。


 **/
@Configuration
@EnableScheduling
//@EnableNeo4jRepositories(basePackages = {"com.digiwin.athena.datamap.repoNeo4j","com.digiwin.athena.kmservice.repository"})
@EnableMongoRepositories(basePackages = "com.digiwin.athena.datamap.repoMongo")
public class DataMapModuleConfiguration {

    public  static  Map<String,Class> codeToClass = new HashMap<>();

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

//    @Primary
//    @Bean
//    public MongoClientOptions mongoClientOptions0(DWMongoListenerMetrics dwMongoListenerMetrics) {
//        return MongoClientOptions.builder()
//                .connectTimeout(10000)
//                .maxConnectionIdleTime(4 * 60 * 1000)
//                .addConnectionPoolListener(dwMongoListenerMetrics).addCommandListener(dwMongoListenerMetrics)
//                .build();
//    }



    @PostConstruct
    public void scanTenantObjects(){
        Set<Class<?>> classes =  ClassUtil.scanPackageBySuper("com.digiwin.athena.entity", TenantObject.class);
        for(Class c : classes){
            codeToClass.put(mongoTemplate.getCollectionName(c),c);
        }
        System.out.println("codeToClass=="+codeToClass);
    }



}
