package com.digiwin.athena.datamap.controller;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("datamap")
public class DatamapController {

    @Autowired
    DataPickService dataPickService;

    @GetMapping("test01")
    public String test01() {
        System.out.println(Thread.currentThread().getName() + " test01....");

        return "ok";
    }

    @GetMapping("test02")
    public Object test02() throws DWBusinessException {

        ServiceUtils.getContext().getProfiles().put("tenantId", "E10PASS14");

        Project project = dataPickService.findByCode("A20240109084537_athenaPaaSDesigner_mainline_project_12123", Project.class);

        return project;
    }

}
