package com.digiwin.athena.datamap.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import java.io.InputStream;

/**
 * API在线文档统一入口
 * @author huak
 * @version 1.0
 */
@Controller
@RequestMapping("/datamap/javadoc")
@Slf4j
public class DocController {

    @Resource
    private ObjectMapper objectMapper;

    /**
     * 入口接口
     */
    @GetMapping("/")
    public String getDoc() {
        return "datamap/javadoc/".concat(getAllInOneDocFileName());
    }

    /**
     * 获取配置文件名称
     */
    public String getAllInOneDocFileName() {
        // 加载 resources 下的 JSON 文件
        try (InputStream inputStream = new ClassPathResource("smart-doc.json").getInputStream()) {
            JsonNode rootNode = objectMapper.readTree(inputStream);
            // 读取 key 为 "allInOneDocFileName" 的内容
            return rootNode.path("allInOneDocFileName").asText();
        } catch (Exception e) {
            log.error("Route==>DocController method=getAllInOneDocFileName error:", e);
            return null;
        }
    }
}
