package com.digiwin.athena.datamap.engine.service.processor;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.engine.constants.MechDatasourceType;
import com.digiwin.athena.datamap.engine.service.inner.MechHelpService;
import com.digiwin.athena.datamap.engine.service.utils.Mutil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.dto.SourceDataDTO;
import com.digiwin.athena.mechanism.vo.DecisionRespItem;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.widgets.choose.MultiStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.RefPlanWidget;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-14 16:09
 **/
@Service
public class DecisionMechDatasourceProcessor implements MechDatasourceProcessor {

    public static final String dataKey = "__DATA_KEY";

    @Autowired
    MechHelpService helpService;

    @Override
    public boolean accept(SourceDataDTO datasource) {
        return MechDatasourceType.decision.name().equals(datasource.getType());
    }

    @Override
    public Object process(SourceDataDTO sourceData) throws DWBusinessException {
        System.out.println("机制开始决策:");
        System.out.println(JSON.toJSONString(sourceData, true));
        Map<String, Object> result = new HashMap<>();
        String tenantId = ServiceUtils.getTenantId();

        MechanismDecision decision = helpService.getMechDecisionByDataSourceCode(sourceData.getCode());

        if (null != decision && null != decision.getConditions()) {
            String paradigmExpression = helpService.paradigmExpression(decision.getMechanismCode(), decision.getDataCode());
            System.out.println("决策获取范式表达式：" + paradigmExpression + " by mechanismCode:" + decision.getMechanismCode() + " dataCode:" + decision.getDataCode());
            CheckWidget paracondition = null;
            if (null != paradigmExpression) {
                paracondition.setType("expression");
                paracondition.setExpression(paradigmExpression);
            }
            List<DecisionRespItem> items = new ArrayList<>();
            List<String> ids = new ArrayList<>();
            List<String> unikeys = sourceData.getUnikeys();
            if (null == unikeys) {
                unikeys = decision.getDataSource().getUnikeys();
            }
            Map variable = new HashMap();
            variable.put("data", sourceData.getDatas());
            // todo 目前仅实现为每条数据做决策的场景，后期遇到其他场景再做扩展
            for (Object data : sourceData.getDatas()) {
                DecisionRespItem item = new DecisionRespItem();
                // item.setData(data);
                String keyvalue = Mutil.uniKey(data, dataKey);
                if (null != keyvalue) {
                    item.setKey(keyvalue);
                } else {
                    item.setKey(Mutil.uniKey(data, unikeys));
                }
                variable.put("item", data);
                // 范式判断
                if (null != paradigmExpression) {
                    boolean check0 = helpService.check(paracondition, variable);
                    System.out.print("数据" + JSON.toJSONString(data));
                    System.out.println(" 范式检查结果为:" + check0);
                    if (!check0) {
                        continue;
                    }
                }

                // 决策条件判断
                for (MultiStrategyWidget condition : decision.getConditions()) {
                    boolean check = helpService.check(condition.getCondition(), variable);
                    if (check) {
                        List<String> targetIds = new ArrayList<>();
                        if (null != condition.getPositiveTargets()) {
                            condition.getPositiveTargets().forEach(tt -> {
                                RefPlanWidget planWidget = ServiceUtils.cast(tt, RefPlanWidget.class);
                                if (null != planWidget.getRefId()) {
                                    targetIds.add(planWidget.getRefId());
                                }
                            });
                        }
                        item.setTargetIds(targetIds);
                        ids.addAll(item.getTargetIds());
                        break;
                    }

                }
                items.add(item);
            }

            if (ids.size() > 0) {
                List<MechanismDecisionTarget> targets = helpService.getSuggestTargetsByIds(ids);
                Map<String, MechanismDecisionTarget> mm = new HashMap<>();
                targets.forEach(t -> {
                    mm.put(t.getTargetId(), t);
                });
                for (DecisionRespItem item : items) {
                    if (null != item.getTargetIds()) {
                        item.setTargets(new ArrayList());
                        for (String id : item.getTargetIds()) {
                            MechanismDecisionTarget mo = mm.get(id);
                            if (null != mo) {
                                item.getTargets().add(mo.getTarget());
                            }

                        }
                    }
                }
            }

            result.put("suggest", items);
        }

        System.out.println("决策返回:");
        System.out.println(JSON.toJSONString(result, true));

        return result;
    }
}
