package com.digiwin.athena.datamap.enums;

import lombok.Getter;

/**
 * IM消息插入链接类型枚举，包含两个属性，type和url
 * @Author QinQiang
 * @Description
 * @Date 2024/7/4
 **/
@Getter
public enum NoticeLinkEnum {

    GLOBAL_INFORMATION("global_information",
            "<a href=\"#atheanaDomain#/smart-view/global-information\" rel=\"noopener noreferrer\"> 跳转全局资讯</a>",
            "<a href=\"#atheanaDomain#/smart-view/global-information\" rel=\"noopener noreferrer\"> 跳轉全局資訊</a>",
            "<a href=\"#atheanaDomain#/smart-view/global-information\" rel=\"noopener noreferrer\"> jump to global information</a>"),

    TASK_DETAIL("task_detail", "", "", ""),
    ;
    private final String type;
    private final String urlCn;
    private final String urlTw;
    private final String urlUs;
    NoticeLinkEnum(String type, String urlCn, String urlTw, String urlUs) {
        this.type = type;
        this.urlCn = urlCn;
        this.urlTw = urlTw;
        this.urlUs = urlUs;
    }

    /**
     * 根据type获取
     * @param type 类型
     * @return 枚举
     */
    public static NoticeLinkEnum getByType(String type) {
        for (NoticeLinkEnum noticeLinkEnum : NoticeLinkEnum.values()) {
            if (noticeLinkEnum.getType().equals(type)) {
                return noticeLinkEnum;
            }
        }
        return null;
    }

}
