package com.digiwin.athena.datamap.filter;

import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


@Component
public class DataMapFilter extends OncePerRequestFilter {

    private static InheritableThreadLocal<LoginInfo> loginInfo = new InheritableThreadLocal<>();

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {

        if(loginInfo.get()==null){
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            LoginInfo info = new LoginInfo();
            info.setToken(token);
            info.setRouterKey(routerKey);
            info.setLocale(locale);
            info.setDesigner(designer);
            loginInfo.set(info);
        }

        try {
            filterChain.doFilter(request,response);
        }catch (Exception e){
            throw e;
        }finally {
            loginInfo.remove();
        }

    }

    public static LoginInfo getLoginInfo(){

        return loginInfo.get();
    }

}
