package com.digiwin.athena.datamap.mechanism.activitybuilder;

import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.definition.AtmcData;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-06 20:02
 **/

public abstract class AbstractActivityBuildService implements ActivityBuildService {

    @Autowired
    DataMapPickService dataPickService;

    @Override
    public List<Activity> build(ActivityWidget ma, MechanismParseContext context) {
        List<Activity> list = new ArrayList<>();
        Activity activity = new Activity();
        activity.setType(ma.getType());
        activity.setConfig(ma.getConfig());
        activity.setName(ma.getName());
        list.add(activity);

        build(ma, context, list);

        return list;
    }

    public abstract void build(ActivityWidget ma, MechanismParseContext context, List<Activity> list);

    protected <T> T convert(Object obj, Class<T> c) {
        T t = dataPickService.convert(obj, c);
        return t;
    }

    public void buildAtmcData(String key, MechanismParseContext context) {
        if (key != null && !context.getAtmcKeys().contains(key)) {
            AtmcData atmcData = new AtmcData();
            atmcData.setAthenaKey(key);
            atmcData.setProVarKey(key);
            context.getTask().getAtmcDatas().add(atmcData);
            context.getAtmcKeys().add(key);
        }
    }

}
