package com.digiwin.athena.datamap.mechanism.checkhandlers;

import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.common.MechanismCheckType;
import org.springframework.stereotype.Service;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-07 10:31
 **/
@Service
public class NotHandler implements CheckHandler {

    @Override
    public boolean accept(CheckWidget check) {
        return MechanismCheckType.not.name().equalsIgnoreCase(check.getType());
    }

    @Override
    public String expression(CheckWidget check) {

        StringBuilder sb = new StringBuilder();

        sb.append("!").append(check.getLeft().getData_name());

        return sb.toString();
    }
}
