package com.digiwin.athena.datamap.mechanism.component;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
//import com.digiwin.athena.common.component.ComponentTypeEnum;
//import com.digiwin.athena.datamap.config.GroupCondition;
//import com.digiwin.athena.datamap.config.activity.ActivityType;
//import com.digiwin.athena.datamap.constant.Constants;
//import com.digiwin.athena.datamap.domain.core.Activity;
//import com.digiwin.athena.datamap.domain.core.DataState;
//import com.digiwin.athena.datamap.domain.core.StateMap;
//import com.digiwin.athena.datamap.domain.core.Task;
//import com.digiwin.athena.datamap.domain.flow.FlowGraph;
//import com.digiwin.athena.datamap.domain.flow.FlowLink;
//import com.digiwin.athena.datamap.domain.flow.FlowNode;
//import com.digiwin.athena.datamap.domain.plugin.PluginBindingPo;
import com.digiwin.athena.config.ActivityType;
import com.digiwin.athena.config.GroupCondition;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.controlSourcehandlers.ControlSourceHandler;
import com.digiwin.athena.datamap.mechanism.paradigm.DataMapParadigmService;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;

import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.common.Constants;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.flow.FlowNode;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.bo.*;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.plugins.PluginRecord;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.activity.GatewayWidget;
import com.digiwin.athena.mechanism.widgets.activity.VariableSetActivityWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.GatewayFlowPath;
import com.digiwin.athena.mechanism.widgets.plan.ActivityPlanWidget;
import io.seata.common.util.CollectionUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import java.util.*;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-03 17:17
 **/
@Slf4j
public abstract class AbstractAbilityComponentHandler extends AbstractComponentHandler {

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Autowired
    List<ControlSourceHandler> sourceHandlers;

    @Autowired
    DataMapPickService dataPickService;

    @Autowired
    PluginService pluginService;

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    DataMapParadigmService dataMapParadigmService;

    private static final String defaultDataCode = "requisitions";

    @Override
    public Object doHandlerApply(MechanismComponentDTO dto, BindingContext context) throws Exception {

        if (ComponentTypeEnum.MechanismControl.name().equalsIgnoreCase(dto.getType())) {
            ControlAbilityBO bo = convert(dto.getAbility(), ControlAbilityBO.class);
            apply(bo, context);
        } else if (ComponentTypeEnum.MechanismDecision.name().equalsIgnoreCase(dto.getType())) {
            DecisionAbilityBO bo = convert(dto.getAbility(), DecisionAbilityBO.class);
            apply(bo, context);
        } else if (ComponentTypeEnum.MechanismLimit.name().equalsIgnoreCase(dto.getType())) {
            LimitAbilityBo bo = convert(dto.getAbility(), LimitAbilityBo.class);
            bo.setCode(dto.getPluginId());
            // pageUIElement表code，用于处理欧博士为空的问题
            bo.setDataViewCode(dto.getDataViewCode());
            apply(bo, context);
        } else if (ComponentTypeEnum.MechanismAssign.name().equalsIgnoreCase(dto.getType())) {
            AssignAbilityBo bo = convert(dto.getAbility(), AssignAbilityBo.class);
            apply(bo, context);
        } else if (ComponentTypeEnum.MechanismDrive.name().equalsIgnoreCase(dto.getType())) {
            DriveAbilityBo bo = convert(dto.getAbility(), DriveAbilityBo.class);
            apply(bo, context);
        }
        return context.getResult();
    }

    @Override
    public Object doHandlerUnApply(MechanismComponentDTO dto, BindingContext context) throws DWException {
        if (ComponentTypeEnum.MechanismControl.name().equalsIgnoreCase(dto.getType())) {
            ControlAbilityBO bo = convert(dto.getAbility(), ControlAbilityBO.class);
            unapply(bo, context);
        } else if (ComponentTypeEnum.MechanismDecision.name().equalsIgnoreCase(dto.getType())) {
            DecisionAbilityBO bo = convert(dto.getAbility(), DecisionAbilityBO.class);
            unapply(bo, context);
        } else if (ComponentTypeEnum.MechanismLimit.name().equalsIgnoreCase(dto.getType())) {
            LimitAbilityBo bo = convert(dto.getAbility(), LimitAbilityBo.class);
            unapply(bo, context);
        } else if (ComponentTypeEnum.MechanismAssign.name().equalsIgnoreCase(dto.getType())) {
            AssignAbilityBo bo = convert(dto.getAbility(), AssignAbilityBo.class);
            unapply(bo, context);
        } else if (ComponentTypeEnum.MechanismDrive.name().equalsIgnoreCase(dto.getType())) {
            DriveAbilityBo bo = convert(dto.getAbility(), DriveAbilityBo.class);
            unapply(bo, context);
        }
        return context.getResult();
    }

    public abstract void apply(MechanismAbility ability, BindingContext context) throws Exception;

    public abstract void unapply(MechanismAbility ability, BindingContext context) throws DWException;

    protected <T> T convert(Object obj, Class<T> c) {
        return mechanismHelpService.convert(obj, c);
    }

    public MechanismParseContext buildTaskFlow(MechanismAbility runnableAbility, BindingContext bindingContext) throws DWBusinessException {
        String pluginId = bindingContext.getPluginId();
        String tenantId = bindingContext.getTenantId();
        MechanismParseContext parseContext = new MechanismParseContext();
        parseContext.setSourceWidget(runnableAbility.getCheckSource());
        parseContext.setBo(runnableAbility);
        parseContext.setBindingContext(bindingContext);
        parseContext.setSourceTarget(runnableAbility.getCheckSource().getTarget());
        if ("tdd".equals(runnableAbility.getCheckSource().getSourcePage())) {
            return parseContext;
        }
        Task task1 = new Task();
        task1.setCode(mechanismHelpService.uid());
        task1.setFlowCode(mechanismHelpService.uid());
        task1.setMasterCode(runnableAbility.getCheckSource().getTarget());
        task1.setName("机制任务");
        task1.setType("business");
        task1.setPattern("MECHANISM");
        task1.setCategory("PROCESS");
        task1.setExecuteType("AUTO");
        task1.setName(runnableAbility.getName());
        task1.setVersion("1.0");
        task1.setTenantId(tenantId);
        task1.setPluginId(pluginId);
        task1.setAssistantType(Constants.mechanismTenantId);
        task1.setPriority(98);
        task1.setMilestone(false);
        task1.setAtmcDatas(new ArrayList<>());
        parseContext.setTask(task1);
        parseContext.setDataCode(runnableAbility.getCheckSource().getDataCode());

        parseSource(runnableAbility.getCheckSource(), parseContext);

        FlowGraph flow1 = basicFlow(task1.getFlowCode());
        flow1.setTenantId(tenantId);
        flow1.setPluginId(pluginId);
        FlowLink lastLink = new FlowLink();
        lastLink.setFrom(flow1.getStartNodeId());
        flow1.getLinks().add(lastLink);
        parseContext.setFlow(flow1);

        // 数据输入输出状态完备
        String dataCode = parseContext.getDataCode();
        String startState = null;
        String endState = null;
        Task taskMaster = null;
        if (null != task1.getMasterCode()) {
            taskMaster = dataPickService.findByCode(task1.getMasterCode(), Task.class);
            if (null != taskMaster) {
                List<String> from = taskMaster.getFrom();
                String firstState = from.get(0);
                startState = from.get(from.size() - 1);
                DataState dataState = dataPickService.findByCode(firstState, DataState.class);
                dataCode = dataState.getDataCode();
            }
        }
        if (null == startState) {
            startState = newState(dataCode, parseContext);
        }

        Task paradigmTask = paradigmTask(dataCode, parseContext);
        StateMap mstateMap = new StateMap();
        if (null != paradigmTask) {
            StateMap stateMap = new StateMap();
            stateMap.setInput(startState);
            String end0 = newState(dataCode, parseContext);
            String end1 = newState(dataCode, parseContext);
            stateMap.getOutput().put("end0", end0);
            stateMap.getOutput().put("end1", end1);
            paradigmTask.getStateMaps().add(stateMap);
            paradigmTask.getFrom();
            paradigmTask.getTo();
            dataPickService.saveTenantObject(paradigmTask, Task.class);
            mstateMap.setInput(end1);
            mstateMap.getOutput().put("end0", end0);
            endState = end0;

        } else {
            mstateMap.setInput(startState);
            String end0 = newState(dataCode, parseContext);
            mstateMap.getOutput().put("end0", end0);
            endState = end0;
        }
        // Output中新增end_noout节点
        mstateMap.getOutput().put("end_noout", mechanismHelpService.uid());
        // 如果要结束流程则输出到一个随机状态
        mstateMap.getOutput().put(flow1.getNooutEndNodeId(), mechanismHelpService.uid());

        task1.getStateMaps().add(mstateMap);
        parseContext.setStartState(startState);
        parseContext.setEndState(endState);

        // 从 parseContext.setFlow(flow1); 后移动到 parseContext.setEndState(endState);之后，为了驱动能力发起任务时能获取到startState初始状态
        if (null != runnableAbility.getPreActivities()) {
            lastLink = applyActivities(lastLink, runnableAbility.getPreActivities(), parseContext);
        }
        parseContext.setLastLink(lastLink);

        if (null != taskMaster) {
            Query query = Query.query(Criteria.where("code").is(taskMaster.getCode()).and("tenantId").is(tenantId));
            List<String> from = taskMaster.getFrom();
            from.add(endState);
            Task tenantTask = new Task();
            tenantTask.setCode(taskMaster.getCode());
            tenantTask.setTenantId(tenantId);
            tenantTask.setVersion(taskMaster.getVersion());
            tenantTask.setFrom(from);
            tenantTask.setPluginId(pluginId);
            // 取主任务的StateMap，设置Input的值为endState
            setStateMaps(taskMaster, tenantTask, startState, endState);

            dataPickService.save(tenantTask, Task.class);
        }
        if (null != task1.getMasterCode()) {
            PluginRecord record = new PluginRecord();
            record.setTenantId(tenantId);
            record.setPluginId(pluginId);
            record.setMasterCode(task1.getMasterCode());
            record.setMechanismCode(parseContext.getBindingContext().getMechanismCode());
            record.setInputState(startState);
            record.setOutputState(endState);
            dataPickService.tenantTemplate().save(record);
        }

        return parseContext;
    }

    protected MechanismParseContext buildContext(MechanismAbility runnableAbility, BindingContext bindingContext) throws DWBusinessException {
        MechanismParseContext parseContext = new MechanismParseContext();
        parseContext.setSourceWidget(runnableAbility.getCheckSource());
        parseContext.setBo(runnableAbility);
        parseContext.setBindingContext(bindingContext);
        parseContext.setSourceTarget(runnableAbility.getCheckSource().getTarget());
        if ("tdd".equals(runnableAbility.getCheckSource().getSourcePage())) {
            return parseContext;
        }
        if ("adp".equals(runnableAbility.getCheckSource().getSourcePage())) {
            return parseContext;
        }
        return parseContext;
    }

    // 设置新的StateMaps，Input的值为endState
    private void setStateMaps(Task taskMaster, Task tenantTask, String startState, String endState) {
        List<StateMap> mstateStateMap = taskMaster.getStateMaps();
        Optional<StateMap> first = mstateStateMap.stream()
                .filter(stateMap -> Objects.equals(startState, stateMap.getInput()))
                .findFirst();
        if (first.isPresent()) {
            StateMap stateMap = new StateMap();
            BeanUtil.copyProperties(first.get(), stateMap);
            stateMap.setInput(endState);
            mstateStateMap.add(stateMap);
            tenantTask.setStateMaps(mstateStateMap);
        }
    }

    public void removeStates(PluginBindingPo binding) {
        // PluginRecord record = mongoTemplate.findOne(Query.query(Criteria.where("tenantId").is(binding.getTenantId()).and("pluginId").in(binding.getPluginIds())),PluginRecord.class);
        // if(null!=record){
        // List<Task> tasks = mongoTemplate.find(Query.query(Criteria.where("tenantId").is(binding.getTenantId()).and("from").in(record.getOutputState())),Task.class);
        // for(Task task:tasks){
        // task.getFrom().remove(record.getOutputState());
        // if(!task.getFrom().contains(record.getInputState())){
        // task.getFrom().add(record.getInputState());
        // }
        // mongoTemplate.save(task);
        // }
        //
        // mongoTemplate.remove(record);
        // }
    }

    public void buildGateway1(SingleStrategyWidget check, MechanismParseContext parseContext) {
        if (null != check) {
            FlowLink lastLink = parseContext.getLastLink();
            FlowLink defaultCondition = null;
            if (null != check.getCondition()) {
                if (null != check.getCondition().getVariables()) {
                    lastLink = applyVariables(lastLink, check.getCondition().getVariables(), parseContext);
                    parseContext.setLastLink(lastLink);
                }
                // lastLink = buildGateway(parseContext.getLastLink(), check.getCondition(), parseContext);

                FlowGraph flow1 = parseContext.getFlow();
                String gatewayId = "gateway_" + mechanismHelpService.uid();
                FlowNode node2 = new FlowNode();
                node2.setId(gatewayId);
                node2.setType("gateway");
                node2.setGateType("exclusive");
                flow1.getNodes().add(node2);
                lastLink.setTo(gatewayId);

                FlowLink link1 = new FlowLink();
                link1.setFrom(gatewayId);
                String cond = mechanismHelpService.toExpression(check.getCondition(), parseContext);
                link1.setCondition(cond);
                link1.setSeq(0);
                flow1.getLinks().add(link1);
                lastLink = link1;
                // todo 目前只存在成功时执行逻辑，所以gateway的else直接指向结束
                defaultCondition = new FlowLink();
                defaultCondition.setFrom(gatewayId);
                defaultCondition.setTo(flow1.getEndNodeId());
                defaultCondition.setSeq(1);
                flow1.getLinks().add(defaultCondition);

            }

            if (null != check.getPositiveTarget()) {
                List<ActivityWidget> widgets = new ArrayList<>();
                ActivityPlanWidget planWidget1 = convert(check.getPositiveTarget(), ActivityPlanWidget.class);
                if (null != planWidget1 && null != planWidget1.getActivityWidget()) {
                    widgets = planWidget1.getActivityWidget();
                }
                lastLink = applyActivities(lastLink, widgets, parseContext);

            }

            // 如果有后续节点gateway的else就不能直接结束，为了保持结构这里加一个空节点
            if (CollectionUtils.isNotEmpty(parseContext.getBo().getPostActivities()) && null != defaultCondition) {
                VariableSetActivityWidget emptyWidget = new VariableSetActivityWidget();
                emptyWidget.setType("variableSet");
                Map<String, Object> config = new HashMap<>();
                List list = new ArrayList();
                MechanismVariable v1 = new MechanismVariable();
                v1.setData_name("test0001");
                v1.setData_type("number");
                v1.setPath("return 1");
                list.add(v1);
                config.put("variables", list);
                emptyWidget.setConfig(config);
                lastLink = applyActivities(lastLink, Arrays.asList(emptyWidget), parseContext);
                defaultCondition.setTo(lastLink.getFrom());
            }

            parseContext.setLastLink(lastLink);
        }
    }

    public String newState(String dataCode, MechanismParseContext parseContext) {
        if (null == dataCode) {
            dataCode = defaultDataCode;
        }
        String state = mechanismHelpService.uid();
        DataState state1 = new DataState();
        state1.setCode(state);
        state1.setDataCode(dataCode);
        state1.setTenantId(parseContext.getBindingContext().getTenantId());
        state1.setPluginId(parseContext.getBindingContext().getPluginId());
        // mongoTemplate.save(state1,dataPickService.tenantCol(DataState.class));
        dataPickService.saveTenantObject(state1, DataState.class);

        return state;
    }

    public void endTaskFlow(FlowLink lastLink, MechanismParseContext context) {
        if (CollectionUtils.isNotEmpty(context.getBo().getPostActivities())) {
            lastLink = applyActivities(lastLink, context.getBo().getPostActivities(), context);
        }
        Task task = context.getTask();
        task.setName("机制任务");
        FlowGraph flow = context.getFlow();
        lastLink.setTo(flow.getEndNodeId());
        if (flow.getNodes().size() > 3) {
            task.getFrom();
            task.getTo();
            // mongoTemplate.save(task);
            // mongoTemplate.save(flow);
            dataPickService.saveTenantObject(task, Task.class);
            dataPickService.saveTenantObject(flow, FlowGraph.class);
        }
    }

    public FlowGraph basicFlow(String code) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(code);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setVersion("1.0");
        flowGraph.setLinks(new ArrayList<>());
        flowGraph.setNodes(new ArrayList<>());

        String startNodeId = "start_" + mechanismHelpService.uid();
        String endNodeId = "end_" + mechanismHelpService.uid();
        String endNodeId2 = "end_" + mechanismHelpService.uid();
        flowGraph.setStartNodeId(startNodeId);
        flowGraph.setEndNodeId(endNodeId);
        flowGraph.setNooutEndNodeId(endNodeId2);
        FlowNode start = new FlowNode();
        start.setId(startNodeId);
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId(endNodeId);
        endNode.setDataKey("end0");
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);

        FlowNode endNode2 = new FlowNode();
        endNode2.setId(endNodeId2);
        endNode2.setDataKey("end_noout");
        endNode2.setType("end");
        flowGraph.getNodes().add(endNode2);

        return flowGraph;
    }

    public void parseSource(SourceWidget checkSource, MechanismParseContext context) throws DWBusinessException {
        if (null == checkSource || null == checkSource.getType()) {
            return;
        }
        for (ControlSourceHandler sourceHandler : sourceHandlers) {
            if (sourceHandler.accept(checkSource)) {
                sourceHandler.parse(checkSource, context);
                break;
            }
        }
    }

    public FlowLink applyActivities(FlowLink lastLink, List<? extends ActivityWidget> mechanismActivities, MechanismParseContext parseContext) {
        FlowLink lastFlowLink = lastLink;
        FlowGraph flow1 = parseContext.getFlow();
        if (null == mechanismActivities) {
            return lastFlowLink;
        }
        for (ActivityWidget mechanismActivity : mechanismActivities) {
            if (mechanismActivity instanceof GatewayWidget) {
                lastFlowLink = applyGatewayActivity(lastFlowLink, (GatewayWidget) mechanismActivity, parseContext);
                continue;
            }

            List<Activity> activities = mechanismHelpService.parseActivity(mechanismActivity, parseContext);
            for (Activity activity1 : activities) {
                activity1.setCode(mechanismHelpService.uid());
                activity1.setTenantId(parseContext.getBindingContext().getTenantId());
                activity1.setPluginId(parseContext.getBindingContext().getPluginId());
                activity1.setVersion("1.0");
                String nodeId = "activity_" + mechanismHelpService.uid();
                FlowNode node1 = new FlowNode();
                node1.setId(nodeId);
                node1.setType("activity");
                node1.setActivityCode(activity1.getCode());
                flow1.getNodes().add(node1);
                lastFlowLink.setTo(nodeId);
                FlowLink link1 = new FlowLink();
                link1.setFrom(nodeId);
                flow1.getLinks().add(link1);
                lastFlowLink = link1;

                // mongoTemplate.save(activity1);
                dataPickService.saveTenantObject(activity1, Activity.class);
            }
        }
        return lastFlowLink;
    }

    protected FlowLink applyGatewayActivity(FlowLink lastLink, GatewayWidget widget, MechanismParseContext parseContext) {

        if (CollectionUtils.isEmpty(widget.getFlowPaths())) {
            return lastLink;
        }

        FlowGraph flow1 = parseContext.getFlow();
        String gatewayId = "gateway_" + mechanismHelpService.uid();
        FlowNode node2 = new FlowNode();
        node2.setId(gatewayId);
        node2.setType("gateway");
        node2.setGateType("exclusive");
        flow1.getNodes().add(node2);
        lastLink.setTo(gatewayId);

        int seq = 0;
        for (GatewayFlowPath flowPath : widget.getFlowPaths()) {
            if (null == flowPath.getCondition()) {
                continue;
            }
            FlowLink condLink = new FlowLink();
            condLink.setFrom(gatewayId);
            String cond = mechanismHelpService.toExpression(flowPath.getCondition(), parseContext);
            condLink.setCondition(cond);
            condLink.setSeq(seq);
            flow1.getLinks().add(condLink);
            FlowLink condLast = applyActivities(condLink, flowPath.getActivityWidgetList(), parseContext);
            // todo 怎么处理分支的流向？直接终止还是可以继续走？先选择后者，让他可以走出机制任务
            if (Boolean.TRUE.equals(flowPath.getNotOutput())) {
                condLast.setTo(flow1.getNooutEndNodeId());
            } else {
                condLast.setTo(flow1.getEndNodeId());
            }

            if (condLink != condLast) {
                flow1.getLinks().add(condLast);
            }

            seq++;
        }

        // 无条件的默认路径
        FlowLink link1 = new FlowLink();
        link1.setFrom(gatewayId);
        link1.setSeq(99);
        flow1.getLinks().add(link1);
        lastLink = link1;

        return lastLink;
    }

    public FlowLink applyVariables(FlowLink lastLink, List<MechanismVariable> variables, MechanismParseContext parseContext) {
        FlowLink lastFlowLink = lastLink;
        if (null != variables && variables.size() > 0) {
            for (MechanismVariable variable : variables) {
                variable.setPath(variable.wrapperedPath());
            }
            VariableSetActivityWidget checkSet = new VariableSetActivityWidget();
            checkSet.setVariables(variables);
            checkSet.setType(ActivityType.variableSet.name());
            lastFlowLink = applyActivities(lastFlowLink, Arrays.asList(checkSet), parseContext);
        }
        return lastFlowLink;
    }

    public FlowLink buildGateway(FlowLink lastLink, CheckWidget condition, MechanismParseContext parseContext) {
        FlowLink lastFlowLink = lastLink;
        if (null == condition) {
            return lastFlowLink;
        }
        FlowGraph flow1 = parseContext.getFlow();
        String gatewayId = "gateway_" + mechanismHelpService.uid();
        FlowNode node2 = new FlowNode();
        node2.setId(gatewayId);
        node2.setType("gateway");
        node2.setGateType("exclusive");
        flow1.getNodes().add(node2);
        lastFlowLink.setTo(gatewayId);

        FlowLink link1 = new FlowLink();
        link1.setFrom(gatewayId);
        String cond = mechanismHelpService.toExpression(condition, parseContext);
        link1.setCondition(cond);
        link1.setSeq(0);
        flow1.getLinks().add(link1);
        lastFlowLink = link1;
        // todo 目前只存在成功时执行逻辑，所以gateway的else直接指向结束
        FlowLink defaultCondition = new FlowLink();
        defaultCondition.setFrom(gatewayId);
        defaultCondition.setTo(flow1.getEndNodeId());
        defaultCondition.setSeq(1);
        flow1.getLinks().add(defaultCondition);

        // 如果有后续节点gateway的else就不能直接结束，为了保持结构这里加一个空节点
        if (CollectionUtils.isNotEmpty(parseContext.getBo().getPostActivities())) {
            VariableSetActivityWidget emptyWidget = new VariableSetActivityWidget();
            emptyWidget.setType("variableSet");
            lastFlowLink = applyActivities(lastLink, Arrays.asList(emptyWidget), parseContext);
            defaultCondition.setTo(lastLink.getFrom());
        }

        return lastFlowLink;
    }

    public Task paradigmTask(String dataCode, MechanismParseContext parseContext) throws DWBusinessException {
        if (null == dataCode || null == parseContext.getBindingContext().getMechanismCode()) {
            return null;
        }
        ParadigmCondition paradigmCondition = dataMapParadigmService.getParadigmConditionByMechanismCode(parseContext.getBindingContext().getMechanismCode());
        if (null == paradigmCondition || null == paradigmCondition.getConditions() || null == paradigmCondition.getFieldMapsTo()) {
            return null;
        }

        String tenantId = parseContext.getBindingContext().getTenantId();
        String pluginId = parseContext.getBindingContext().getPluginId();

        Map<String, String> keyMaps = new HashMap<>();
        for (Map.Entry<String, List<FieldMapInfo>> en : paradigmCondition.getFieldMapsTo().entrySet()) {
            for (FieldMapInfo info : en.getValue()) {
                if (dataCode.equals(info.getData_name())) {
                    keyMaps.put(en.getKey(), info.getField());
                    break;
                }
            }
        }

        String expression = dataMapParadigmService.parseParadigmCondition(paradigmCondition, keyMaps, null);
        if (null == expression) {
            log.warn("paradigm expression is null,by paradigmCondition:" + paradigmCondition);
            return null;
        }

        Task task1 = new Task();
        task1.setCode(mechanismHelpService.uid());
        task1.setFlowCode(mechanismHelpService.uid());
        task1.setType("business");
        task1.setPattern("PARADIGM");
        task1.setCategory("PROCESS");
        task1.setExecuteType("AUTO");
        task1.setName("范式任务");
        task1.setVersion("1.0");
        task1.setTenantId(tenantId);
        task1.setPluginId(pluginId);
        task1.setAssistantType(Constants.mechanismTenantId);
        task1.setPriority(99);
        task1.setMilestone(false);
        task1.setAtmcDatas(new ArrayList<>());
        task1.getConfig().put("_mechanismCode", parseContext.getBindingContext().getMechanismCode());
        task1.getConfig().put("_dataCode", dataCode);

        FlowGraph flow1 = basicFlow(task1.getFlowCode());
        flow1.setTenantId(tenantId);
        flow1.setPluginId(pluginId);
        flow1.getNodes().forEach(node -> {
            node.setDataKey(null);
        });

        Activity createData = new Activity();
        createData.setCode(mechanismHelpService.uid());
        createData.setPattern("PARADIGM");
        createData.setPluginId(pluginId);
        createData.setTenantId(tenantId);
        createData.setType("createData");
        createData.getConfig().put("_mechanismCode", parseContext.getBindingContext().getMechanismCode());
        createData.getConfig().put("_dataCode", dataCode);
        createData.getConfig().put("dataVariable", "data");
        createData.getConfig().put("groupType", "ByCondition");
        List<GroupCondition> conditions = new ArrayList();
        GroupCondition condition1 = new GroupCondition();
        condition1.setSeq(0);
        condition1.setDataKey("end1");
        condition1.setCondition(expression);
        condition1.setName("判断成功");
        conditions.add(condition1);
        GroupCondition condition2 = new GroupCondition();
        condition2.setSeq(1);
        condition2.setDataKey("end0");
        condition2.setName("默认");
        conditions.add(condition2);
        createData.getConfig().put("conditions", conditions);

        FlowNode createDataNode = new FlowNode();
        createDataNode.setId("createDataNode");
        createDataNode.setType("activity");
        createDataNode.setActivityCode(createData.getCode());
        flow1.getNodes().add(createDataNode);

        FlowLink link1 = new FlowLink();
        link1.setFrom(flow1.getStartNodeId());
        link1.setTo(createDataNode.getId());
        flow1.getLinks().add(link1);
        FlowLink link2 = new FlowLink();
        link2.setFrom(createDataNode.getId());
        link2.setTo(flow1.getEndNodeId());
        flow1.getLinks().add(link2);

        // mongoTemplate.save(createData);
        // mongoTemplate.save(flow1);
        dataPickService.saveTenantObject(createData, Activity.class);
        dataPickService.saveTenantObject(flow1, FlowGraph.class);

        return task1;
    }

}
