package com.digiwin.athena.datamap.mechanism.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.impl.DataMapTaskService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.config.DataType;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.process.Process;
import com.digiwin.athena.domain.core.process.ProcessConfigLink;
import com.digiwin.athena.domain.core.process.ProcessConfigNode;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.dto.TaskAndActivity;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.bo.AssignAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.vo.SourceFieldVO;
import com.digiwin.athena.mechanism.vo.TargetFieldVO;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.assign.AdvancedUserDefinitionWidget;
import com.google.common.base.Preconditions;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @PACKAGE_NAME: com.digiwin.athena.datamap.mechanism.component
 * @NAME: AssignAbilityHandler
 * @USER: 罗群
 * @DATE: 2022/9/15
 * @PROJECT_NAME: 智驱中台
 */
@Service
public class AssignAbilityHandler extends AbstractAbilityComponentHandler {

    private static final String MECHANISM_TASK_DATA = "_mechanism_taskData_";

    private static final String MECHANISM_BASIC_DATA = "_mechanism_basicData_";

    private static final String MECHANISM_EXECUTOR = "_executorByMechanism_";

    @Autowired
    DataMapTaskService dataMapTaskService;

    @Autowired
    private DataMapKgService dataMapKgService;

    @Autowired
    DataPickService dataPickService;

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws Exception {
        AssignAbilityBo source = (AssignAbilityBo) ability;
        unapply(source, context);
        Task task = dataPickService.findByCode(source.getCheckSource().getTarget(), Task.class);
        Preconditions.checkNotNull(task);
        //应用2.0版本的流程走process
        Process process = null;
        if (task.getProcessId() != null) {
            process = dataPickService.systemTemplate().findOne(Query.query(Criteria.where("code").is(task.getProcessId())), Process.class);
        }
        if (process != null && source.getAdvancedUserDefinitionWidget() != null) {
            applyForTwoPointZeroApp(process, source, context);
            return;
        } else if (process != null) {
            applyAssignWithoutPreActivityForTwoPointZeroApp(process, source, context);
            return;
        }
        List<ActivityWidget> activityWidgets = generatePreActivities(source, context);
        source.setPreActivities(activityWidgets);
        if (CollectionUtils.isNotEmpty(source.getPreActivities())) {
            MechanismParseContext parseContext = buildTaskFlow(source, context);
            applyMechanismTask(source, context);
            endTaskFlow(parseContext.getLastLink(), parseContext);
        } else {
            applyMechanismTask(source, context);
        }

    }

    private void applyAssignWithoutPreActivityForTwoPointZeroApp(Process process, AssignAbilityBo source, BindingContext context) throws Exception {
        Preconditions.checkNotNull(process.getProcessConfig(), "ProcessConfig is null");
        String sonTaskCode = source.getCheckSource().getTarget();
        List<ProcessConfigNode> nodes = process.getProcessConfig().getNodes();
        ProcessConfigNode targetNode = nodes.stream()
                .filter(each -> each.getId().equals(sonTaskCode))
                .findAny()
                .orElseThrow(() -> new DWException("Target Task not found"));
        replaceExecutorUser(targetNode, source.getAssignTo());
        process.setPluginId(context.getPluginId());
        process.setTenantId(ServiceUtils.getTenantId());
        process.setVersion(null);
        process.setId(null);
        dataPickService.tenantTemplate().insert(process);
    }

    private void replaceExecutorUser(ProcessConfigNode targetNode, UserDefinition assignTo) {
        if (targetNode.getExecutor() != null
                && "personnel".equals(targetNode.getExecutor().get("type"))
                && assignTo.getChoosePolicy().equals("single")
                && assignTo.getIdentities().iterator().next().getPerformerType().equals("user")) {
            targetNode.getExecutor().put("source", "personnel");
            targetNode.getExecutor().put("type", "personnel");
            Map<String, String> user = new HashMap<>();
            user.put("userId", assignTo.getIdentities().iterator().next().getPerformerValue().toString());
            List<Map<String, String>> users = new ArrayList<>();
            users.add(user);
            targetNode.getExecutor().put("personnel", users);
        }
        // TODO duty,dept 暂不支持
    }

    public void applyForTwoPointZeroApp(Process process, AssignAbilityBo source, BindingContext context) throws Exception {
        Preconditions.checkNotNull(process, "Process is null");
        Preconditions.checkNotNull(process.getProcessConfig(), "ProcessConfig is null");
        List<ProcessConfigNode> nodes = process.getProcessConfig().getNodes();
        String sonTaskCode = source.getCheckSource().getTarget();
        ProcessConfigNode targetNode = nodes.stream()
                .filter(each -> each.getId().equals(sonTaskCode))
                .findAny()
                .orElseThrow(() -> new DWException("Target Task not found"));
        List<ProcessConfigNode> assignNodes = generateAssignNodes(source, context);
        Preconditions.checkArgument(!assignNodes.isEmpty());
        replaceExecutorForTargetNodeExecutorUser(targetNode, context.getPluginId(), assignNodes.get(assignNodes.size() - 1).getId());
        generateNewGraph(process, context, sonTaskCode, assignNodes);
        dataPickService.tenantTemplate().insert(process);
    }

    public void generateNewGraph(Process process, BindingContext context, String sonTaskCode, List<ProcessConfigNode> assignNodes) throws DWException {
        List<ProcessConfigLink> links = process.getProcessConfig().getLinks();
        ProcessConfigLink toTargetLink = links.stream()
                .filter(each -> each.getToId().equals(sonTaskCode))
                .findAny()
                .orElseThrow(() -> new DWException("Target Task not found in links to"));
        links.remove(toTargetLink);
        List<ProcessConfigLink> newLinks = new ArrayList<>(links);
        List<ProcessConfigNode> nodes = process.getProcessConfig().getNodes();
        List<ProcessConfigNode> newNodes = new ArrayList<>(nodes);
        int i = 0;
        ProcessConfigNode lastNode = nodes.stream()
                .filter(each -> each.getId().equals(toTargetLink.getFromId()))
                .findAny()
                .orElseThrow(() -> new DWException("Target Task not found in links from"));
        for (ProcessConfigNode each : assignNodes) {
            newNodes.add(each);
            ProcessConfigLink link = new ProcessConfigLink();
            link.setFromId(lastNode.getId());
            link.setToId(each.getId());
            link.setId(mechanismHelpService.uid());
            newLinks.add(link);
            lastNode = each;
            if (i++ == assignNodes.size() - 1) {
                ProcessConfigLink linkToTarget = new ProcessConfigLink();
                linkToTarget.setFromId(each.getId());
                linkToTarget.setToId(sonTaskCode);
                linkToTarget.setId(mechanismHelpService.uid());
                newLinks.add(linkToTarget);
            }
        }
        process.getProcessConfig().setNodes(newNodes);
        process.getProcessConfig().setLinks(newLinks);
        process.setPluginId(context.getPluginId());
        process.setTenantId(ServiceUtils.getTenantId());
        process.setVersion(null);
        process.setId(null);
    }

    public void replaceExecutorForTargetNodeExecutorUser(ProcessConfigNode targetNode, String pluginId, String id) {
        if (targetNode.getExecutor() != null && "personnel".equals(targetNode.getExecutor().get("type"))) {
            targetNode.getExecutor().put("source", "variable");
            Map<String, String> user = new HashMap<>();
            user.put("userId", "return [$variables['" + id + "']['" + MECHANISM_EXECUTOR + pluginId + "']];");
            targetNode.getExecutor().put("variable", user);
        }
    }

    public List<ProcessConfigNode> generateAssignNodes(AssignAbilityBo source, BindingContext context) throws Exception {
        List<ProcessConfigNode> nodes = new ArrayList<>();
        nodes.add(generateEspNode(source.getCheckSource().getTarget(), "task-detail", context.getPluginId()));
        nodes.add(generateEspNode(source.getAdvancedUserDefinitionWidget().getSourceField().getBasicDataCode(), "basic-data", context.getPluginId()));
        nodes.add(generateScriptNode(source.getAdvancedUserDefinitionWidget(), context.getPluginId(), nodes));
        return nodes;
    }

    private ProcessConfigNode generateEspNode(String code, String type, String capacityCode) throws Exception {
        Object task = "task-detail".equals(type)
                ? dataMapTaskService.getActivityDefinition(code, type)
                : dataMapTaskService.getActivityDefinition(code, type);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(task));
        JSONObject dataSources = jsonObject.getJSONObject("dataSources");
        JSONObject pages = jsonObject.getJSONObject("pages");
        JSONArray dataStates = pages == null ? null : pages.getJSONArray("dataStates");
        String schema = null;
        if (dataStates != null) {
            JSONObject submitType = dataStates.getJSONObject(0).getJSONObject("submitType");
            schema = submitType == null ? null : submitType.getString("schema");
        }
        JSONObject dataSourceJson = null;
        if (schema != null) {
            dataSourceJson = dataSources.getJSONObject(schema);
        }
        if (dataSourceJson == null) {
            schema = String.valueOf(dataSources.keySet().toArray()[0]);
            dataSourceJson = dataSources.getJSONObject(schema);
        }
        StringBuilder request = new StringBuilder();
        // TODO 考虑如何增加请求参数
        request.append("return {\n std_data: {\n parameter: {\n")
                .append("\n} \n} \n};");
        StringBuilder response = new StringBuilder();
        response.append("var response = $(response);\n")
                .append("var tSuccess = true;\n")
                .append("var tErrorMessage = '';\n")
                .append("if (Object.keys(response).length===0){tErrorMessage='Success';var ").append(schema).append("=''}\n")
                .append("else if (response['std_data']['execution']['code'] == '0') { \n")
                .append("tErrorMessage = 'Success';\n")
                .append("var ").append(schema).append("= response['std_data']['parameter']['").append(schema).append("'];\n")
                .append("} else {\n")
                .append("tSuccess = false;\n")
                .append("tErrorMessage = response['std_data']['execution']['description'];}\n")
                .append("return {\n")
                .append("'").append(this.getProcessVariableKey(type, capacityCode)).append("': ").append(schema).append("\n")
                .append("};");
        ProcessConfigNode node = new ProcessConfigNode();
        node.setTransfer(true);
        node.setName("ESP");
        Map<String, Boolean> returnMap = new HashMap();
        returnMap.put("base", true);
        returnMap.put("dataMapping", true);
        node.set_isValidPassed(returnMap);
        node.setSubType("ESP");
        String nodeId = mechanismHelpService.uid();
        node.setId("ServiceTask_" + nodeId);
        node.setType("ServiceTask");
        node.set_nodeId(nodeId);
        MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO().setZh_CN("ESP").setZh_TW("ESP").setEn_US("ESP");
        Map<String, MultiLanguageDTO> multiLanguageMap = new HashMap<>();
        multiLanguageMap.put("name", multiLanguageDTO);
        node.setLang(multiLanguageMap);
        node.set_nodeType("AutoEsp");
        Map<String, Object> executor = new HashMap<>();
        executor.put("performer", "Athena");
        executor.put("variable", new HashMap<>());
        executor.put("source", "NONE");
        executor.put("type", "robot");
        node.setExecutor(executor);
        Map<String, Object> serviceConfig = new HashMap<>();
        // TODO 产品名称
        // serviceConfig.put("prod", "DPBAS");
        serviceConfig.put("method", "");
        serviceConfig.put("isAsync", false);
        Map<String, String> scheduleRule = new HashMap<>();
        scheduleRule.put("schedule_type", "");
        serviceConfig.put("scheduleRule", scheduleRule);
        serviceConfig.put("type", "ESP");
        serviceConfig.put("serviceName", dataSourceJson.getString("serviceName"));
        // header.put("digi-dap-service-chain-info",
        // "2,1:taskengine^4ee415bd-8302-4f00-a97b-bf721858d0e2,taskengine^157f8e18-49de-49f7-9c8a-2f2cedd09bf7,taskengine^bc49cd59-39b3-4a74-8743-21fa5ce67c22");
        // header.put("digi-middleware-auth-user", "5fefd69c-d756-42cb-956c-8b89dda032cb");
        // header.put("task-uid", "1805063067462021120");
        // header.put("activity-uid", "1805063067822731264");
        // header.put("locale", "zh_CN");
        // header.put("project-id", "PU_197b9b59f4821000");
        // header.put("project-serial-number", "invoke1805063066161786880");
        // header.put("routerKey", "IntelligentDriveCenterWorkbench");
        // header.put("activity-code", "7590d04981bb46bea30234aa80ccadd9");
        // header.put("token", "5fefd69c-d756-42cb-956c-8b89dda032cb");
        Map<String, Object> headerMap = new HashMap<>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        serviceConfig.put("header", headerMap);
        serviceConfig.put("requestScript", request.toString());
        serviceConfig.put("responseScript", response.toString());
        node.setServiceConfig(serviceConfig);
        return node;
    }

    private String getProcessVariableKey(String type, String capacityCode) {
        if ("task-detail".equals(type)) {
            return MECHANISM_TASK_DATA + capacityCode;
        } else {
            return MECHANISM_BASIC_DATA + capacityCode;
        }
    }

    private ProcessConfigNode generateScriptNode(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, String capacityCode, List<ProcessConfigNode> nodes) {
        ProcessConfigNode node = new ProcessConfigNode();
        node.setTransfer(true);
        node.setName("脚本");
        Map<String, Boolean> returnMap = new HashMap<>();
        returnMap.put("base", true);
        node.set_isValidPassed(returnMap);
        node.setSubType("SCRIPT");
        String nodeId = mechanismHelpService.uid();
        node.setId("ServiceTask_" + nodeId);
        node.setType("ServiceTask");
        node.set_nodeId(nodeId);
        MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO().setZh_CN("脚本").setZh_TW("脚本").setEn_US("脚本");
        Map<String, MultiLanguageDTO> multiLanguageMap = new HashMap<>();
        multiLanguageMap.put("name", multiLanguageDTO);
        node.setLang(multiLanguageMap);
        node.set_nodeType("AutoScript");
        Map<String, Object> executor = new HashMap<>();
        executor.put("performer", "Athena");
        executor.put("variable", new HashMap<>());
        executor.put("source", "NONE");
        executor.put("type", "robot");
        node.setExecutor(executor);
        Map<String, Object> serviceConfig = new HashMap<>();
        Map<String, String> scheduleRule = new HashMap<>();
        scheduleRule.put("schedule_type", "");
        serviceConfig.put("scheduleRule", scheduleRule);
        SourceFieldVO sourceField = advancedUserDefinitionWidget.getSourceField();
        TargetFieldVO targetField = advancedUserDefinitionWidget.getTargetField();
        String taskDataVariableKey = MECHANISM_TASK_DATA + capacityCode;
        String basicDataVariableKey = MECHANISM_BASIC_DATA + capacityCode;
        StringBuilder response = new StringBuilder();
        response.append("var taskData = $variables['" + nodes.get(0).getId() + "']['" + taskDataVariableKey + "'];\n")
                .append("var basicData = $variables['" + nodes.get(1).getId() + "']['" + basicDataVariableKey + "'];\n")
                .append("var sourceTaskFieldVal = taskData ? taskData[0]." + sourceField.getTaskField().getData_name() + ":'_';\n")
                .append("var executorByMechanism; \n")
                .append("for(var i = 0; i < basicData.length; i++) {\n")
                .append(" var sourceBasicFieldVal = basicData[i]." + sourceField.getBasicDataField().getData_name() + ";\n")
                .append(" if(sourceBasicFieldVal === sourceTaskFieldVal){\n")
                .append(" executorByMechanism = basicData[i]." + targetField.getBasicDataField().getData_name() + ";\n")
                .append(" break; \n")
                .append(" } \n")
                .append("} \n")
                .append("return {\n")
                .append("'").append(MECHANISM_EXECUTOR + capacityCode).append("': executorByMechanism \n")
                .append("};");
        serviceConfig.put("responseScript", response.toString());
        serviceConfig.put("id", "ServiceTask_" + nodeId);
        serviceConfig.put("type", "SCRIPT");
        node.setServiceConfig(serviceConfig);
        return node;
    }

    private List<ActivityWidget> generatePreActivities(AssignAbilityBo source, BindingContext context) throws DWException {
        if (null == source.getAdvancedUserDefinitionWidget()) {
            return Collections.emptyList();
        }
        return dataMapKgService.generatePreActivities(source.getAdvancedUserDefinitionWidget(), context.getPluginId());
    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postRemovePlugin(binding);

        pluginService.removeTenantPlugin(binding, DataMapPickService.tableTenantObjectAdaptation(Activity.class));
        // 清除2.0应用指派高级规则生成的 process
        dataPickService.tenantTemplate().remove(
                Query.query(Criteria.where("pluginId").is(context.getPluginId()).and("tenantId").is(ServiceUtils.getTenantId())), Process.class);
    }

    public void applyMechanismTask(AssignAbilityBo mtask, BindingContext bindingContext) throws DWException {

        if (mtask.getAssignTo() != null && null != mtask.getCheckSource() && null != mtask.getCheckSource().getTarget()) {

            String taskCode = mtask.getCheckSource().getTarget();
            TaskAndActivity taskAndActivity = dataMapTaskService.getTaskAndMilestoneActivity(taskCode);
            if (null != taskAndActivity.getActivity()) {
                TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
                tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
                tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
                tenantObjectAdaptation.setCode(taskAndActivity.getActivity().getCode());
                tenantObjectAdaptation.setDateType(DataType.object);
                tenantObjectAdaptation.setPath("$.executor");
                tenantObjectAdaptation.setValue(mtask.getAssignTo());
                dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(Activity.class));
            }
        }

    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismAssign.name().equalsIgnoreCase(dto.getType());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return null;
    }
}
