package com.digiwin.athena.datamap.mechanism.component;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.JsExpression;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionConverter;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.common.JsExpressionType;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.widgets.config.DecisionScene;
import com.digiwin.athena.mechanism.widgets.config.DecisionTarget;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.Rule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @program: codes
 * @description: 根据字段下拉数据进行决策的模型
 * @author: Tuo
 * @create: 2023-03-31 08:49
 **/
@Deprecated
@Service
public class DecisionAbilityHandler2 {

    @Autowired
    PresetLibraryService presetLibraryService;

    @Autowired
    JsExpressionConverter jsExpressionConverter;

    @Autowired
    MechanismHelpService mechanismHelpService;

    public void apply(MechanismAbility ability, BindingContext context) throws DWException {
        DecisionAbilityBO bo = (DecisionAbilityBO) ability;

        unapply(ability, context);
        Rule rule = buildRule(bo, context);
        System.out.println(JSON.toJSONString(rule, true));
        presetLibraryService.saveRule(rule);
    }

    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        DecisionAbilityBO bo = (DecisionAbilityBO) ability;

        presetLibraryService.cleanRule(context.getPluginId());
    }

    private Rule buildRule(DecisionAbilityBO bo, BindingContext context) throws DWBusinessException {

        context.setJsExpressionType(JsExpressionType.currentControl);

        Rule rule = new Rule();
        Map<String, Object> content = new HashMap<>();
        rule.setContent(content);
        rule.setApplication(context.getApplication());
        rule.setTenantId(context.getTenantId());
        rule.setPluginId(context.getPluginId());
        rule.setDomain(PresetDomainEnum.ACTIVITY);
        rule.setDomainId(bo.getCheckSource().getTarget());
        rule.setKey(mechanismHelpService.uid());
        content.put("condition", "true");
        content.put("key", "connection");
        content.put("relationIsLinkage", false);
        // content.put("description",validate.getMsg());
        // content.put("errorMessage",validate.getMsg());

        String path = null;
        String schema = null;
        String fullpath = bo.getVariable().getPath();
        if (null != fullpath) {
            int len = fullpath.lastIndexOf(".");
            path = fullpath.substring(0, len);
            schema = fullpath.substring(len + 1, fullpath.length());
            content.put("path", path);
            content.put("schema", schema);
        }
        List relations = new ArrayList();
        content.put("relations", relations);
        Map relation = new HashMap();
        relation.put("path", schema);
        relations.add(relation);
        List operations = new ArrayList();
        relation.put("operations", operations);
        Map operation = new HashMap();
        operations.add(operation);
        operation.put("type", "attribute");
        operation.put("name", "enableOptions");
        operation.put("script", "");

        // script
        Set<String> funNames = new HashSet<>();
        StringBuilder sb = new StringBuilder();
        for (DecisionScene scene : bo.getDecisionOption().getScenes()) {
            JsExpression jsExpression = jsExpressionConverter.convert(scene.getCheck(), context);
            if (null != jsExpression) {
                funNames.addAll(jsExpression.getFunction());
                if (null != jsExpression.getExpression()) {
                    sb.append("if(").append(jsExpression.getExpression()).append("){ var list = [");
                    int len = scene.getTargets().size();
                    for (int i = 0; i < len; i++) {
                        DecisionTarget target = scene.getTargets().get(i);
                        if (target.getValue() instanceof String) {
                            sb.append("'").append(target.getValue()).append("'");
                        } else {
                            sb.append(target.getValue());
                        }
                        if (i < len - 1) {
                            sb.append(",");
                        }
                    }
                    sb.append("]; return list;} ");

                }
            }
        }

        sb.append(" return []");

        String functionExp = jsExpressionConverter.functionExpression(funNames);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }

        // 拼接立即执行函数结构
        sb.insert(0, "(() => {");
        sb.append("})()");

        operation.put("script", sb.toString());

        return rule;
    }

    public static void main(String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append("aaaa");
        sb.insert(0, "AAA");
        System.out.println(sb.toString());
    }

}
