package com.digiwin.athena.datamap.mechanism.component;

import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWException;
//import com.digiwin.athena.common.DataType;
//import com.digiwin.athena.common.OpType;
//import com.digiwin.athena.datamap.domain.TenantObjectAdaptation;
//import com.digiwin.athena.datamap.domain.core.DataState;
//import com.digiwin.athena.datamap.domain.core.Task;
//import com.digiwin.athena.datamap.domain.plugin.PluginBindingPo;
//import com.digiwin.athena.datamap.domain.view.PageView;
import com.digiwin.athena.config.DataType;
import com.digiwin.athena.config.OpType;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.datamap.utils.CommonUtils;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.common.DecisionSubType;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-27 15:16
 **/
@Deprecated
@Service
public class DecisionAbilityHandlerOld extends AbstractAbilityComponentHandler {

    @Autowired
    PluginService pluginService;
    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    DecisionAbilityHandler2 decisionAbilityHandler2;
    @Autowired
    DecisionAbilityHandler3 decisionAbilityHandler3;

    private Object processorTemplate = null;
    private Object operationTemplate = null;

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws DWException {
        DecisionAbilityBO bo = (DecisionAbilityBO) ability;
        if (DecisionSubType.option.name().equalsIgnoreCase(bo.getSubType())) {
            decisionAbilityHandler2.apply(ability, context);
            return;
        }
        if (DecisionSubType.openwindow.name().equalsIgnoreCase(bo.getSubType())) {
            decisionAbilityHandler3.apply(ability, context);
            return;
        }

        unapply(ability, context);

        String tenantId = context.getTenantId();
        String pluginId = context.getPluginId();
        MechanismDecision decision = new MechanismDecision();
        decision.setTenantId(tenantId);
        decision.setPluginId(pluginId);
        decision.setMechanismCode(context.getMechanismCode());
        decision.setDataSource(bo.getCheckSource());
        decision.setConditions(bo.getChooses());

        List<MechanismDecisionTarget> targetList = new ArrayList<>();
        bo.getTargets().forEach(decisionTarget -> {
            MechanismDecisionTarget target = new MechanismDecisionTarget();
            target.setTenantId(tenantId);
            target.setPluginId(pluginId);
            target.setTargetId(decisionTarget.getTargetId());
            target.setTargetType(decisionTarget.getTargetType());
            target.setTarget(decisionTarget.getTarget());
            targetList.add(target);
        });
        dataPickService.tenantTemplate().insertAll(targetList);

        // todo 页面修改
        String taskCode = bo.getCheckSource().getTarget();
        if (null != taskCode) {
            Task task = dataPickService.findBetter(taskCode, Task.class);
            if (null != task && null != task.getPageCode()) {
                PageView pageView = dataPickService.findBetter(task.getPageCode(), PageView.class);
                if (null != pageView) {
                    TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
                    tenantObjectAdaptation.setTenantId(tenantId);
                    tenantObjectAdaptation.setPluginId(pluginId);
                    tenantObjectAdaptation.setCode(pageView.getCode());
                    tenantObjectAdaptation.setDateType(DataType.array);
                    tenantObjectAdaptation.setOp(OpType.add);
                    tenantObjectAdaptation.setPath("$.dataProcessors");
                    tenantObjectAdaptation.setValue(getProcessorTemplate(bo.getCheckSource().getCode()));
                    dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataPickService.tableTenantObjectAdaptation(PageView.class));
                }
            }
            // 获取当前任务数据定义code
            if (null != task && task.getFrom().size() > 0) {
                String state = task.getFrom().get(0);
                DataState dataState = dataPickService.findBetter(state, DataState.class);
                if (null != dataState) {
                    decision.setDataCode(dataState.getDataCode());
                }
            }
        }

        dataPickService.tenantTemplate().save(decision);

    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        DecisionAbilityBO bo = (DecisionAbilityBO) ability;
        if (DecisionSubType.option.name().equalsIgnoreCase(bo.getSubType())) {
            decisionAbilityHandler2.unapply(ability, context);
            return;
        }
        if (DecisionSubType.openwindow.name().equalsIgnoreCase(bo.getSubType())) {
            decisionAbilityHandler3.unapply(ability, context);
            return;
        }
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postRemovePlugin(binding);

    }

    private Object getProcessorTemplate(String sourceCode) {
        if (null == processorTemplate) {
            Map<String, String> param = new HashMap<>();
            param.put("sourceCode", sourceCode);
            processorTemplate = CommonUtils.entity("mechanism/decision_dataprocessor.json", param);
        }
        return processorTemplate;
    }

    private Object getOperationTemplate(String sourceCode) {
        if (null == operationTemplate) {
            Map<String, String> param = new HashMap<>();
            param.put("sourceCode", sourceCode);
            operationTemplate = CommonUtils.entity("mechanism/decision_operation.json", param);
        }
        return operationTemplate;
    }

    public static void main(String[] args) {
        Map<String, String> param = new HashMap<>();
        PageView obj = CommonUtils.entity("mechanism/test.json", param, PageView.class);
        Object obj2 = JSONPath.eval(obj.getPages().get("task-detail"), "$.dataStates[?(@.code='waitting')].operations");
        System.out.println(obj2);
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return Boolean.FALSE;
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return null;
    }
}
