package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWException;
//import com.digiwin.athena.common.component.ComponentTypeEnum;
//import com.digiwin.athena.datamap.domain.flow.FlowLink;
//import com.digiwin.athena.datamap.domain.plugin.PluginBindingPo;
//import com.digiwin.athena.datamap.domain.view.PageView;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-09 16:57
 **/
@Deprecated
@Service
public class LimitAbilityHandlerOld extends AbstractAbilityComponentHandler {

    @Autowired
    PluginService pluginService;
    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    private List<LimitHandler> limitHandlers;

    @Autowired
    PresetLibraryService presetLibraryService;
    @Autowired
    DataMapKgService dataMapKgService;

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws Exception {

        unapply(ability, context);
        LimitAbilityBo bo = (LimitAbilityBo) ability;
        MechanismParseContext parseContext = buildTaskFlow(bo, context);

        List<SingleStrategyWidget> strategies = bo.getStrategies();
        if (null != strategies) {
            for (SingleStrategyWidget widget : strategies) {
                // todo 这里有个问题，多个条件的variable能同时放到流程变量里吗？应该会有问题
                if (null != widget.getCondition() && null != widget.getCondition().getVariables()) {
                    FlowLink lastLink = applyVariables(parseContext.getLastLink(),
                            widget.getCondition().getVariables(), parseContext);
                    parseContext.setLastLink(lastLink);
                }
                for (LimitHandler limitHandler : limitHandlers) {
                    if (limitHandler.accept(widget)) {
                        limitHandler.handler(widget, parseContext);
                        break;
                    }
                }
            }
        }
        if ("tdd".equals(parseContext.getSourceWidget().getSourcePage())) {
            return;
        }
        endTaskFlow(parseContext.getLastLink(), parseContext);

    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of(context.getTenantId(), context.getPluginId());
        pluginService.postRemovePlugin(binding);
        presetLibraryService.cleanRule(context.getPluginId());
        // 清除定义中机制插入的机制参数 重新存储
        LimitAbilityBo bo = (LimitAbilityBo) ability;
        if ("dataEntrySource".equals(bo.getCheckSource().getType())) {
            // kgService.cleanActionsByPluginId(bo.getCheckSource().getTarget(),context.getPluginId());
        }
        if ("taskSource".equals(bo.getCheckSource().getType())) {
            Query query = new Query();
            query.addCriteria(Criteria.where("pluginId").is(context.getPluginId()).and("tenantId").is(context.getTenantId()).and("code").is(bo.getCheckSource().getTarget()));
            dataPickService.tenantTemplate().remove(query, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
        if ("projectSource".equals(bo.getCheckSource().getType())) {
            Query query = new Query();
            query.addCriteria(Criteria.where("pluginId").is(context.getPluginId()).and("tenantId").is(context.getTenantId()).and("code").is(bo.getCheckSource().getTarget()));
            dataPickService.tenantTemplate().remove(query, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismLimit.name().equalsIgnoreCase(dto.getType()) && ObjectUtils.isEmpty(dto.getMechanismVersion());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return null;
    }
}
