package com.digiwin.athena.datamap.mechanism.controlSourcehandlers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.impl.ProjectService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.common.MechanismCheckSourceType;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.source.ProjectSourceWidget;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 项目为数据源转化为第一个任务作为数据源
 * @author: Tuo
 * @create: 2022-12-30 11:23
 **/
@Service
public class ProjectSourceHandler extends AbstractControlSourceHandler {

    @Autowired
    DataPickService dataPickService;

    @Autowired
    PluginService pluginService;

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    ProjectService projectService;

    @Autowired
    MechanismHelpService mechanismHelpService;
    @Override
    public boolean accept(SourceWidget source) {
        return MechanismCheckSourceType.projectSource.name().equals(source.getType());
    }

    @Override
    public void parse(SourceWidget source, MechanismParseContext context) throws DWBusinessException {

        Task task1 = context.getTask();
        ProjectSourceWidget projectSourceWidget = dataPickService.convert(source, ProjectSourceWidget.class);
        context.setSourceWidget(projectSourceWidget);
        String projectCode = projectSourceWidget.getTarget();
        Project project = dataPickService.findByCode(projectCode, Project.class);
        if (null != project) {
            if (null == context.getDataCode()) {
                context.setDataCode(project.getInit().getDataCode());
            }
            Map<String, Object> query = new HashMap<>();
            query.put("from", Arrays.asList(project.getInit().getCode()));
            List<Task> tasks = dataPickService.find(BasicQuery.of(query, null), Task.class);
            if (CollectionUtils.isNotEmpty(tasks)) {
                Task taskMaster = tasks.get(0);
                task1.setMasterCode(taskMaster.getCode());
            }
            // 手动发起项目，rule规则是以发起页面pageView对应的任务作为domainId
            if (Boolean.TRUE.equals(project.getManualAble())) {
                Task taskMaster3 = projectService.manualProjectPageTask(projectCode);
                if (null != taskMaster3) {
                    context.setProjectPageTarget(taskMaster3.getCode());
                }

            }

        }

    }
}
