package com.digiwin.athena.datamap.mechanism.convert;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 * @author tang jie cheng
 * @date 2023-04-07 14:16
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class HookDynamicFunction {

    /**
     * HookBO的hook名称，如gridReadyHook，afterViewInitHook，通过此字段反射给HookBO赋值
     */
    private String hookName;
    /**
     * 方法js名称
     */
    private String functionName;
    /**
     * 需要绑定的sourceId
     */
    private String sourceId;

    /**
     * 动态参数
     */
    private Map<String, Object> parameter;
}
