package com.digiwin.athena.datamap.mechanism.convert;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.mechanism.widgets.config.MechanismCheckConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-31 09:25
 **/
@Service
public class JsExpressionConverter {

    @Autowired
    JSFunctions jsFunctions;
    @Autowired
    List<JsExpressionParser> parsers;

    public JsExpression convert(MechanismConditionConfig conditionConfig, BindingContext context) throws DWBusinessException {

        for (JsExpressionParser parser : parsers) {
            if (parser.accept(conditionConfig)) {
                return parser.parse(conditionConfig, context);
            }
        }
        return null;
    }

    public JsExpression convert(MechanismCheckConfig checkConfig, BindingContext context) throws DWBusinessException {
        if (null != checkConfig && null != checkConfig.getGroups()) {
            return convertByGroups(checkConfig.getGroups(), context);

        }
        return null;
    }

    public JsExpression convertByGroups(List<MechanismConditionGroup> groups, BindingContext context) throws DWBusinessException {
        if (groups.isEmpty()) {
            return null;
        }
        Set<String> functions = new HashSet<>();
        Set<DynamicFunction> dynamicFunction = new HashSet<>();
        List<String> orExpression = new ArrayList<>();
        for (MechanismConditionGroup group : groups) {
            List<JsExpression> expressions = new ArrayList<>();
            for (MechanismConditionConfig condition : group.getConditions()) {
                JsExpression exp = convert(condition, context);
                if (null != exp && null != exp.getExpression()) {
                    expressions.add(exp);
                    functions.addAll(exp.getFunction());
                    dynamicFunction.addAll(exp.getDynamicFunction());
                }
            }
            if (expressions.size() > 0) {
                StringBuilder sb = new StringBuilder();
                int len = expressions.size();
                for (int i = 0; i < len; i++) {
                    JsExpression expression = expressions.get(i);
                    sb.append("(").append(expression.getExpression()).append(")");
                    if (i < len - 1) {
                        sb.append(" && ");
                    }
                }
                orExpression.add(sb.toString());
            }
        }
        JsExpression jsExpression = new JsExpression();
        jsExpression.setFunction(functions);
        jsExpression.setDynamicFunction(dynamicFunction);
        if (orExpression.size() == 1) {
            jsExpression.setExpression(orExpression.get(0));
        } else {
            StringBuilder sb = new StringBuilder();
            int len = orExpression.size();
            for (int i = 0; i < len; i++) {
                String expression = orExpression.get(i);
                sb.append("(").append(expression).append(")");
                if (i < len - 1) {
                    sb.append(" || ");
                }
            }
            jsExpression.setExpression(sb.toString());
        }
        return jsExpression;
    }
    public String functionExpression(Set<String> functionNames) {
        StringBuilder sb = new StringBuilder();
        for (String name : functionNames) {
            String fun = jsFunctions.function(name);
            if (null != fun) {
                sb.append(fun).append(";");
            }
        }
        return sb.toString();
    }

    /**
     * 动态函数  需要替换其中的值
     * @param functions
     * @return
     */
    public String dynamicFunctionExpression(Set<DynamicFunction> functions) {
        StringBuilder sb = new StringBuilder();
        for (DynamicFunction function : functions) {
            String name = function.getFunctionName();
            String fun = jsFunctions.function(name);
            if (null != fun) {
                Map<String, String> parameter = function.getParameter();
                if (!parameter.isEmpty()) {
                    for (Map.Entry<String, String> entry : parameter.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        fun = fun.replaceAll(key, value);
                    }
                }
                sb.append(fun).append(";");
            }
        }
        return sb.toString();
    }
}
