package com.digiwin.athena.datamap.mechanism.convert.parsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.JsExpression;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionParser;
import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashMap;

/**
 * 限制的高级条件  其他不确定能不能复用   如果不能复用  type用其他的  重新实现类
 * {@link \resources\files\functions\highGradeCondition.js}
 *
 * @Author: tangJieCheng-17257
 * @Date:
 * @return:
 **/
@Service
@Slf4j
class HighGradeExpressionParser implements JsExpressionParser {

    @Override
    public boolean accept(MechanismConditionConfig config) {
        return config.getType().equalsIgnoreCase("highGrade");
    }
    @Override
    public JsExpression parse(MechanismConditionConfig config, BindingContext context) throws DWBusinessException {
        HashMap<String, String> parameters = new HashMap<>();
        MechanismVariable left = config.getLeft();
        parameters.put("highGradeParameter1", jointPath(left.getFrom()));
        parameters.put("highGradeParameter2", jointPath(left.getTo()));
        MechanismVariable right = config.getRight();
        parameters.put("highGradeParameter3", jointPath(right.getFrom()));
        parameters.put("highGradeParameter4", right.getTo().getValue().toString());
        JsExpression jsExpression = new JsExpression();
        jsExpression.setExpression("isMatch");
        jsExpression.getDynamicFunction().add(DynamicFunction.builder().functionName("highGradeCondition").parameter(parameters).build());
        return jsExpression;
    }

    private String jointPath(MechanismVariable variable) {
        String str = variable.getData_name();
        if (variable.getPath().isEmpty()) {
            str = variable.getPath() + "." + variable.getData_name();
        }
        return str;
    }
}
