package com.digiwin.athena.datamap.mechanism.convert.parsers;

import com.alibaba.fastjson.JSON;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
/**
 * @title: StringParser
 * @author: linc
 * @date 2023/9/27 11:41
 * @version: 1.0
 */

public class IMContentParser {

    public static void main(String[] args) {
        String content = "【缺料通知】";
        // String content = "【缺料通知】制令单号：$wo_no$ 生产批号：$plot_no$ 项目名称：$project_name$ 制程名称：$op_name$ 缺少物料：$bad_material$ ";
        System.out.println(parseVariables("material_shortage_template", content));
    }

    public static String parseVariables(String msgCode, String content) {
        List<Variable> variables = new ArrayList<Variable>();
        Pattern pattern = Pattern.compile("\\$(.*?)\\$");
        Matcher matcher = pattern.matcher(content);

        while (matcher.find()) {
            String key = matcher.group(1);
            variables.add(new Variable(key, "$(" + key + ")"));
        }

        return JSON.toJSONString(new Template(msgCode, variables));
    }

    public static class Template {

        List<Variable> variableList;
        String code;
        public Template(String code, List<Variable> variableList) {
            this.code = code;
            this.variableList = variableList;
        }

        public List<Variable> getVariableList() {
            return variableList;
        }

        public void setVariableList(List<Variable> variableList) {
            this.variableList = variableList;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    public static class Variable {

        private String key;
        private String value;

        public Variable(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return key;
        }

        public String getValue() {
            return value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
