package com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.mechanism.common.MechanismVariable;

/**
 * @Description 自定义函数解析
 * @Author liugl
 * @Date 2024/6/28 14:26
 **/
public interface CustomFuncParser {

    /**
     * 判断选择解析器
     * @param type
     * @return 结果
     */
    boolean accept(String type);

    /**
     * 根据名称获取函数输出类型
     *
     * @param name
     * @return 结果
     */
    String getOutPutTypeByName(String name);

    /**
     * 判断选择解析器
     * @param mechanismVariable 判断条件
     * @param metaDataList 表格数据
     * @return 结果
     */
    Object parse(MechanismVariable mechanismVariable, JSONArray metaDataList);
}
