package com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Optional;

/**
 * @Description 最大值函数解析
 * @Author liugl
 * @Date 2024/7/1 9:53
 **/
@Service
@Slf4j
public class MaxParser implements CustomFuncParser {

    @Override
    public boolean accept(String type) {
        return MechanismEnum.FunctionType.MAX.getCode().equalsIgnoreCase(type);
    }

    @Override
    public String getOutPutTypeByName(String dataType) {
        return MechanismEnum.FunctionType.MAX.getOutputType();
    }

    @Override
    public BigDecimal parse(MechanismVariable mechanismVariable, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            return null;
        }
        String dataName = mechanismVariable.getData_name();
        Optional<BigDecimal> maxValue = metaDataList.stream().map(v -> {
            JSONObject metaDataObj = JSON.parseObject(JSON.toJSONString(v));
            BigDecimal sourceValue = null;
            try {
                sourceValue = metaDataObj.getBigDecimal(dataName);
            } catch (Exception e) {
                log.warn("MaxParser.parse 表格数据转换失败，数据为：{}", v);
            }
            return sourceValue;
        }).filter(v -> null != v).max(BigDecimal::compareTo);
        return maxValue.isPresent() ? maxValue.get() : null;
    }
}
