package com.digiwin.athena.datamap.mechanism.convert.parsers.hooks;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.HookDynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @Description 赋值
 * @Author liugl
 * @Date 2024/8/7 20:12
 **/
@Service
public class AssignmentParser implements HooksParser {

    @Override
    public boolean accept(MechanismConditionConfig config) {
        return MechanismEnum.ComponentType.ASSIGNMENT.getCode().equalsIgnoreCase(config.getMetaFieldType());
    }

    @Override
    public HooksInfo parse(MechanismConditionConfig config, BindingContext context,
                           PageView pageView, Map<String, Object> parameters) throws DWBusinessException {
        String selectorLayoutId = DataMapUtils.getTableLayoutId(pageView);
        HooksInfo hooksInfo = new HooksInfo().setDynamicFunctions(Sets.newHashSet(new HookDynamicFunction()
                .setFunctionName("openAssignment")
                .setHookName("gridReadyHook")
                .setParameter(parameters)
                .setSourceId(selectorLayoutId)));
        JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(parameters.get("hookOperationTypes")));
        String operationType = jsonArray.getString(0);
        if ("click".equalsIgnoreCase(operationType)) {
            hooksInfo.getDynamicFunctions().add(new HookDynamicFunction()
                    .setFunctionName("clickAssignment")
                    .setHookName("beforeSubmitHook")
                    .setParameter(parameters)
                    .setSourceId(selectorLayoutId));
        } else if ("modify".equalsIgnoreCase(operationType)) {
            hooksInfo.getDynamicFunctions().add(new HookDynamicFunction()
                    .setFunctionName("modifyAssignment")
                    .setHookName("valueChangesHook")
                    .setParameter(parameters)
                    .setSourceId(selectorLayoutId));
        }
        return hooksInfo;
    }

    @Override
    public Map<String, Object> buildParameters(MechanismAbility ability, Map<String, Object> parameters) {
        return parameters;
    }
}
