package com.digiwin.athena.datamap.mechanism.convert.parsers.hooks;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.bo.MechanismApiInfoBO;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-31 11:35
 **/
@Service
public class NumberParser implements HooksParser {

    @Override
    public boolean accept(MechanismConditionConfig config) {
        return MechanismEnum.ComponentType.NUMERIC.getCode().equalsIgnoreCase(config.getMetaFieldType());
    }

    @Override
    public HooksInfo parse(MechanismConditionConfig config, BindingContext context, PageView pageView, Map<String, Object> parameters) throws DWBusinessException {
        MechanismApiInfoBO apiInfo = config.getMechanismApiInfo();
        if (apiInfo == null) {
            throw new DWBusinessException();
        }
        return new HooksInfo();
    }

    @Override
    public Map<String, Object> buildParameters(MechanismAbility ability, Map<String, Object> parameters) {
        return parameters;
    }
}
