package com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.HookDynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.hooks.HooksParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.CustomFunctionParser;
import com.digiwin.athena.datamap.mechanism.limithandler.ReminderLimitHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.service.impl.DataMapMechanismService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.jayway.jsonpath.JsonPath;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class LimitConditionParser implements JudgeBasisParser {

    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Autowired
    DataMapKgService dataMapKgService;

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Autowired
    CustomFunctionParser customFunctionParser;

    @Autowired
    ReminderLimitHandler reminderLimitHandler;

    @Autowired
    DataMapMechanismService dataMapMechanismService;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.ConditionType.LIMIT_CONDITION.getCode().equalsIgnoreCase(type);
    }

    @Override
    public void parse(MechanismAbility ability, PageView pageView, BindingContext context, HooksInfo hooksInfoAll) {
        LimitAbilityBo bo = (LimitAbilityBo) ability;
        context.getMechanismVariables().put("hookSelectorInitDataFieldParam", bo);
        if (CollectionUtils.isEmpty(bo.getStrategies())) {
            log.error("无场景数据，入参：{}", ability);
            return;
        }

        try {
            Map<String, Object> parameters = new HashMap<>();
            Map<String, Object> paramsInfo = new HashMap<>();
            Map<String, Object> req = new HashMap<>();
            Map<String, Object> apiInfo = new HashMap<>();
            List<Object> apiList = new ArrayList<>();

            if (null == pageView.getDataSources() || pageView.getDataSources().isEmpty()) {
                return;
            }
            // TODO 仅支持单数据源场景
            Object dataSourceTable = pageView.getDataSources().values().iterator().next();
            Object dataKeys = JsonPath.read(dataSourceTable, "$.dataKeys");

            MechanismConditionConfig mechanismCondition = new MechanismConditionConfig();
            SingleStrategyWidget limitSingleStrategy = bo.getStrategies().get(0);
            PlanWidget positiveTarget = limitSingleStrategy.getPositiveTarget();
            // 场景号用法类似于api条件中的url
            paramsInfo.put("api", "/mechanism/postQueryApiResult");
            paramsInfo.put("requestJson", new Object());
            paramsInfo.put("ability", buildAbility(bo));
            paramsInfo.put("abilityType", "MechanismLimit");
            paramsInfo.put("limitConditionType", positiveTarget.getConditionType());
            paramsInfo.put("limitActionType", positiveTarget.getActionType());
            paramsInfo.put("keyFieldNameList", JSONArray.parseArray(JSON.toJSONString(dataKeys)));
            paramsInfo.put("operationTypes", ability.getCheckSource().getOperationTypes());
            paramsInfo.put("watchFields", ability.getCheckSource().getWatchFields());
            // 内部api不需要Esp，因此设置为false
            paramsInfo.put("isNeedEsp", Boolean.FALSE);
            req.put("req", paramsInfo);
            apiInfo.put("params", req);
            // 多场景时，仅调用一次api,但每个场景都会有决策方案，如果决策方案选择从页面获取，无法将其和场景一一对应上
            // 因此选择从api结果返回决策方案
            apiInfo.put("type", "api");
            apiList.add(apiInfo);

            parameters.put("hookTableDataKey", pageView.getDataSources().keySet().iterator().next());
            parameters.put("hookApiList", apiList);
            parameters.put("hookKeyFieldNameList", JSONArray.parseArray(JSON.toJSONString(dataKeys)));
            parameters.put("hookCapacityCode", ability.getCode());
            parameters.put("hookOperationTypes", ability.getCheckSource().getOperationTypes());
            parameters.put("hookWatchFields", ability.getCheckSource().getWatchFields());

            mechanismCondition.setMetaFieldType(limitSingleStrategy.getActionHookType());
            HooksParser hooksParser = mechanismParserFactory.getHooksParserByConfig(mechanismCondition);
            if (null == hooksParser) {
                log.error("LimitConditionParser.parseScene 获取HooksParser失败，入参：{}", bo);
            }
            hooksParser.buildParameters(ability, parameters);
            HooksInfo hooksInfo = hooksParser.parse(mechanismCondition, context, pageView, parameters);
            hooksInfoAll.getDynamicFunctions().add(new HookDynamicFunction()
                    .setFunctionName("initKmHookLibr")
                    .setHookName("afterViewInitHook")
                    .setSourceId(DataMapUtils.getTableLayoutId(pageView))
                    .setParameter(new HashMap<>()));
            hooksInfoAll.getDynamicFunctions().addAll(hooksInfo.getDynamicFunctions());
        } catch (Exception e) {
            log.error("解析pageView获取决策条件失败，参数scenes：{}", bo, e);
        }
    }

    private JSONObject buildAbility(LimitAbilityBo bo) {
        PlanWidget positiveTarget = bo.getStrategies().get(0).getPositiveTarget();
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(positiveTarget));
        jsonObject.put("ruleContent", null);

        JSONObject jsonObject1 = JSONObject.parseObject(JSON.toJSONString(bo));
        jsonObject1.getJSONArray("strategies").getJSONObject(0).put("positiveTarget", jsonObject);
        return jsonObject1;
    }
}
