package com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;

/**
 * @Description 根据不同的判断类型解析条件 详见MechanismEnum.RightCondType
 * @Author liugl
 * @Date 2024/6/28 14:26
 **/
public interface RightCondTypeParser {

    /**
     * 判断选择解析器
     *
     * @param type
     * @return 结果
     */
    boolean accept(String type);

    /**
     * 前置处理解析自定义函数，并将值放入functionValue；或者将自定义函数、枚举值等的value值放入functionValue进行统一处理
     *
     * @param config         判断条件
     * @param metaDataList 表格数据
     * @return 结果
     */
    CustomFuncResult preParse(MechanismConditionConfig config, JSONArray metaDataList);

    /**
     * 解析数据，将解析结果存入metaData中，返回结果是表示是否可以直接对其他表格数据做同样操作。例如exist()判断通过后，对所有数据操作
     *
     * @param config         判断条件
     * @param metaDataList 表格数据
     * @param metaData     当前判断中表格一行数据
     * @return 结果
     */
    CustomFuncResult parse(MechanismConditionConfig config, JSONObject metaData, JSONArray metaDataList);

}
