package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionConverter;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.LimitFormValidate;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.Rule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
生成rules信息
 **/
@Service
public class FormValidateLimitHandler implements LimitHandler {

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Autowired
    PresetLibraryService presetLibraryService;

    @Autowired
    JsExpressionConverter jsExpressionConverter;
    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.limitFormValidate.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) {

        Rule rule = buildRule(singleStrategyWidget, parseContext);

        presetLibraryService.saveRule(rule);

    }

    private Rule buildRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) {
        LimitFormValidate validate = mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(), LimitFormValidate.class);
        Rule rule = new Rule();
        Map<String, Object> content = new HashMap<>();
        rule.setContent(content);
        rule.setApplication(parseContext.getBindingContext().getApplication());
        rule.setTenantId(parseContext.getBindingContext().getTenantId());
        rule.setPluginId(parseContext.getBindingContext().getPluginId());
        rule.setDomain(PresetDomainEnum.ACTIVITY);
        rule.setDescription(validate.getMsg());
        rule.setDomainId(parseContext.getProjectPageTarget() == null ? parseContext.getSourceTarget() : parseContext.getProjectPageTarget());
        rule.setKey(mechanismHelpService.uid());
        content.put("condition", mechanismHelpService.toExpression(singleStrategyWidget.getCondition(), parseContext));
        // content.put("relationIsLinkage",false);
        content.put("description", validate.getMsg());
        content.put("errorMessage", validate.getMsg());
        if (null != validate.getRuleContent()) {
            content.putAll(JSON.parseObject(JSON.toJSONString(validate.getRuleContent())));
        }

        String path = null;
        String schema = null;
        String relationPath = validate.getRelationPath();
        if (null != validate.getPath()) {
            String fullpath = validate.getPath();
            int len = fullpath.lastIndexOf(".");
            path = fullpath.substring(0, len);
            schema = fullpath.substring(len + 1, fullpath.length());
            content.put("path", path);
            content.put("schema", schema);

        }

        switch (validate.getValidateType()) {
            case "unEditAble":
                content.put("key", "disabled");
                content.put("scope", "EDIT");
                break;

            // "content" : {
            // "schema" : "register_personnel_id ",
            // "path" : "wait_register_personnel",
            // "condition" : "true",
            // "relations" : [
            // {
            // "path" : "plan_register_date",
            // "operations" : [
            // {
            // "name" : "disabledDate",
            // "type" : "attribute",
            // "script" : "(current)=>{var today=new Date();today=new Date(today.getFullYear(),today.getMonth(),today.getDate());return(current<today);}"
            // }
            // ]
            // }
            // ],
            // "key" : "connection"
            // },

            case "dateLimit":
                content.put("key", "connection");
                List relations = new ArrayList();
                content.put("relations", relations);
                Map relation1 = new HashMap();
                relations.add(relation1);
                relation1.put("path", relationPath == null ? schema : relationPath);
                List operations = new ArrayList();
                relation1.put("operations", operations);
                Map operation1 = new HashMap();
                operations.add(operation1);
                operation1.put("name", "disabledDate");
                operation1.put("type", "attribute");
                operation1.put("script", "");
                if (validate.getDateLimitType() == 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("(current)=>{var today=new Date();today=new Date(today.getFullYear(),today.getMonth(),today.getDate()");
                    sb.append("+").append(validate.getDateLimit());
                    sb.append(");return(current<today);}");
                    operation1.put("script", sb.toString());
                } else if (validate.getDateLimitType() == 1) {
                    operation1.put("script", mechanismHelpService.replaceMechanismVariable(validate.getScript(), parseContext, true));
                }
                break;
            case "required":
                content.put("key", "required");
                break;
            case "hidden":
                content.put("key", "hidden");
                break;

            default:;
        }

        return rule;
    }

    public static void main(String[] args) {
        String path = "aa.bb.cc.dd";
        int len = path.lastIndexOf(".");
        String path0 = path.substring(0, len);
        String path1 = path.substring(len + 1, path.length());
        System.out.println(path0);
        System.out.println(path1);
    }

}
