package com.digiwin.athena.datamap.mechanism.limithandler;

import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.config.RuleTrigger;
import com.digiwin.athena.mechanism.widgets.plan.LimitTaskActionPlan;
import com.digiwin.athena.preset.Rule;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
@Slf4j
public class LimitTaskActionHandler extends LimitCommonUtil implements LimitHandler {

    @Autowired
    PresetLibraryService presetLibraryService;

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.limitTaskActionPlan.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        List<Rule> rules = buildRules(singleStrategyWidget, parseContext);
        for (Rule rule : rules) {
            presetLibraryService.saveRule(rule);
        }
    }

    private List<Rule> buildRules(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        LimitTaskActionPlan limitTaskActionPlan = mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(),
                LimitTaskActionPlan.class);
        ArrayList<Rule> list = new ArrayList<>();
        for (MechanismConditionConfig condition : limitTaskActionPlan.getConditions()) {
            Rule rule = new Rule();
            Map<String, Object> content = new HashMap<>();
            rule.setContent(content);
            ruleCommonSet(parseContext, rule);

            RuleContent ruleContent = limitTaskActionPlan.getRuleContent();
            RuleTrigger trigger = ruleContent.getTrigger();
            String limitType = condition.getLimitType();

            if (null != condition.getLeft().getPath()) {
                String fullPath = condition.getLeft().getPath();
                int len = fullPath.lastIndexOf(".");
                content.put("path", fullPath.substring(0, len));
                content.put("schema", fullPath.substring(len + 1));
            }
            // content.put("scope","EDIT");
            // content.put("targetSchema",condition.getLeft().getData_name()); 暂时不知道取什么
            switch (limitType) {
                case "required":// 必填
                    content.put("key", "required");
                    trigger.setPoint("default");
                    content.put("validatorType", "error");
                    attributeAndLang(content, condition.getLeft(), "errorMessage", "必填");
                    if (limitTaskActionPlan.getIsAsync()) {
                        content.put("checkEmptyForAsyncRequired", true);
                    }
                    break;
                case "hidden":// 隐藏
                    content.put("key", "hidden");
                    trigger.setPoint("default");
                    break;
                case "disabled":// 只读
                    content.put("key", "disabled");
                    trigger.setPoint("default");
                    break;
                case "scopeLimit":// scopeLimit
                    content.put("key", "scopeLimit");
                    break;
                default:
                    break;
            }

            content.put("trigger", trigger);

            content.put("description", "limitTaskAction");
            // 条件不同 拼接不同的if()中的内容
            Set<DynamicFunction> dynamicFunctions = new HashSet<>();
            StringBuilder sb = new StringBuilder();
            ArrayList<String> expressionList = new ArrayList<>();
            expression(singleStrategyWidget, limitTaskActionPlan, parseContext, dynamicFunctions, expressionList);
            String expression = String.join(" && ", expressionList);
            sb.append(expression);
            String functionExp = jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
            if (null != functionExp) {
                sb.insert(0, functionExp);
            }
            if (limitTaskActionPlan.getIsAsync()) {
                trigger.setCondition(sb.toString());
            } else {
                content.put("condition", sb.toString());
            }
            list.add(rule);

        }
        return list;
    }

}
