package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.action.LimitAction;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Service
@Slf4j
public class ActionParser implements LimitActionParser {

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitActionType.LIMIT_ACTION.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Object parse(MechanismApiInfoDTO apiInfoDTO) throws Exception {
        LimitAbilityBo bo = mechanismHelpService.convert(apiInfoDTO.getAbility(), LimitAbilityBo.class);
        LimitAction limitAction = bo.getLimitAction();
        List<MechanismConditionConfig> conditions = limitAction.getConditions();
        if (CollectionUtils.isEmpty(conditions)) {
            return null;
        }
        // 满足场景的表格数据map {主键拼接字符， 决策方案}
        Map<String, Object> accordSceneDataMap = new HashMap<>();
        LinkedList<String> keyFieldNameList = new LinkedList<>();
        if (apiInfoDTO != null) {
            keyFieldNameList.addAll(apiInfoDTO.getKeyFieldNameList());
        }
        JSONArray metaDataList = JSON.parseArray(JSON.toJSONString(apiInfoDTO.getTableData()));
        metaDataList.stream().forEach(v -> {
            JSONObject rowData = JSON.parseObject(JSON.toJSONString(v));
            JSONObject accordRowData = new JSONObject();
            JSONObject keyObj = new JSONObject();
            accordRowData.put("key", keyObj);
            accordRowData.put("row_data", v);
            StringBuilder priKeyValue = new StringBuilder();
            for (int n = 0; n < keyFieldNameList.size(); n++) {
                keyObj.put(keyFieldNameList.get(n), rowData.get(keyFieldNameList.get(n)));
                priKeyValue.append(rowData.get(keyFieldNameList.get(n)));
            }
            accordSceneDataMap.put(priKeyValue.toString(), accordRowData);
        });
        return accordSceneDataMap.values();
    }
}
