package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.ConditionParser;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.condition.AutoProcessCondConfig;
import com.digiwin.athena.mechanism.widgets.condition.AutoProcessCondition;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DatamapAutoProcessParser implements LimitActionParser {

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Autowired
    DataMapKgService dataMapKgService;

    @Autowired
    ConditionParser conditionParser;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitActionType.AUTO_PROCESS.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Object parse(MechanismApiInfoDTO apiInfoDTO) throws Exception {
        LimitAbilityBo bo = mechanismHelpService.convert(apiInfoDTO.getAbility(), LimitAbilityBo.class);
        List<AutoProcessCondConfig> scenes = bo.getAutoProcess().getScenes();
        if (CollectionUtils.isEmpty(scenes)) {
            return null;
        }

        List<Object> result = new ArrayList<>();
        scenes.stream().forEach(v -> {
            Map<String, Object> dataMap = new HashMap<>();
            Boolean isSameLineReplace = ObjectUtils.isEmpty(v.getSourceFieldConfig().getIsSameLineReplace()) ? Boolean.FALSE : v.getSourceFieldConfig().getIsSameLineReplace();
            Object sourceField = parseFieldConfig(v.getSourceFieldConfig(), apiInfoDTO, v.getSourceFieldConfig().getGroups(), true);
            Object targetField = parseFieldConfig(v.getTargetFieldConfig(), apiInfoDTO, v.getTargetFieldConfig().getGroups(), false);
            dataMap.put("type", v.getSourceFieldConfig().getRightCondType());
            dataMap.put("value", v.getSourceFieldConfig().getValue());
            dataMap.put("sourceField", sourceField);
            if (isSameLineReplace) {
                JSONObject sourceJsonObject = JSONObject.parseObject(JSON.toJSONString(sourceField));
                JSONObject targetJsonObject = JSONObject.parseObject(JSON.toJSONString(targetField));
                sourceJsonObject.put("fields", targetJsonObject.getJSONArray("fields"));
                dataMap.put("targetField", sourceJsonObject);
            } else {
                dataMap.put("targetField", targetField);
            }
            result.add(dataMap);
        });
        return result;
    }

    /**
     * 解析数据
     *
     * @param fieldConfig
     * @param apiInfoDTO
     * @return
     */
    private Object parseFieldConfig(AutoProcessCondition fieldConfig, MechanismApiInfoDTO apiInfoDTO, List<MechanismConditionGroup> groups, Boolean isSingle) {
        Map<String, Object> result = new HashMap<>();
        result.put("fields", fieldConfig.getFields().stream().map(v -> v.getData_name()).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(groups)) {
            if (ObjectUtils.isEmpty(apiInfoDTO.getTableData())) {
                log.error("无表格数据，入参：{}", apiInfoDTO);
                return null;
            }
            // step1：获取数据
            JSONArray metaDataList = JSON.parseArray(JSON.toJSONString(apiInfoDTO.getTableData()));
            // 满足场景的表格数据map {主键拼接字符， 决策方案}
            Map<String, Object> accordTableDataMap = new HashMap<>();

            // step2：循环遍历场景处理数据
            accordTableDataMap.putAll(conditionParser.parseSingleScene(groups, metaDataList, apiInfoDTO, null));
            JSONArray accordTableDataArray = JSONArray.parseArray(JSON.toJSONString(accordTableDataMap.values()));
            log.info("parseFieldConfig，accordTableDataArray：{}", JSON.toJSONString(accordTableDataArray));
            List<Object> rowDataList = accordTableDataArray.stream().map(v -> {
                JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(v));
                Object rowData = jsonObject.get("row_data");
                return rowData;
            }).collect(Collectors.toList());
            result.put("row_data", isSingle ? (CollectionUtils.isEmpty(rowDataList) ? null : Lists.newArrayList(rowDataList.get(0))) : rowDataList);
        }
        if (isSingle && MechanismEnum.RightCondType.MECHANISM_VARIABLE.getCode().equalsIgnoreCase(fieldConfig.getRightCondType())) {
            List<String> variableIds = Lists.newArrayList(fieldConfig.getValue());
            Object variableObj = dataMapKgService.getVariableListSimple(variableIds, Boolean.TRUE);
            JSONObject variableJsonObj = JSONObject.parseObject(JSON.toJSONString(variableObj));
            fieldConfig.setValue(variableJsonObj.get(fieldConfig.getValue()).toString());
        }
        return result;
    }
}