package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitCondition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.ConditionParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.CustomFunctionParser;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DataMapBusinessConditionParser implements LimitConditionParser {

    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Autowired
    DataMapKgService dataMapKgService;

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Autowired
    CustomFunctionParser customFunctionParser;

    @Autowired
    ConditionParser conditionParser;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitConditionType.BUSINESS.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Boolean parse(MechanismApiInfoDTO apiInfoDTO) {
        LimitAbilityBo bo = mechanismHelpService.convert(apiInfoDTO.getAbility(), LimitAbilityBo.class);
        if (ObjectUtils.isEmpty(bo.getBusinessCondition())) {
            log.error("无场景数据，入参：{}", apiInfoDTO);
            return null;
        }
        if (ObjectUtils.isEmpty(apiInfoDTO.getTableData())) {
            log.error("无表格数据，入参：{}", apiInfoDTO);
            return null;
        }
        // 筛选出符合场景的所有表格数据
        // step1：获取数据
        JSONArray metaDataList = JSON.parseArray(JSON.toJSONString(apiInfoDTO.getTableData()));
        // 满足场景的表格数据map {主键拼接字符， 决策方案}
        Map<String, Object> accordTableDataMap = new HashMap<>();
        // step2：循环遍历场景处理数据
        List<MechanismConditionGroup> groups = bo.getBusinessCondition().getGroups();
        accordTableDataMap.putAll(conditionParser.parseSingleScene(groups, metaDataList, apiInfoDTO, null));
        if (CollectionUtils.isEmpty(accordTableDataMap)) {
            return Boolean.FALSE;
        }
        List<Object> rowDataList = accordTableDataMap.values().stream().map(v -> {
            JSONObject rowDataJson = mechanismHelpService.convert(v, JSONObject.class);
            Object rowDataObj = rowDataJson.get("row_data");
            return rowDataObj;
        }).collect(Collectors.toList());
        apiInfoDTO.setTableData(rowDataList);
        return Boolean.TRUE;
    }
}
