package com.digiwin.athena.datamap.povo;

import com.digiwin.athena.domain.common.BaseObject;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 待办工作台设定中的条件生效范围
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ConditionScopeDTO extends BaseObject implements Serializable {

    /**
     * 任务或者项目的id，用来排序
     */
    private String id;

    @NotBlank
    private String appCode;

    private String appName;
    /**
     * 任务名称或项目名称
     */
    @NotBlank
    private String name;
    /**
     * 原始编码
     */
    @NotBlank
    private String fieldCode;

    /**
     * 任务和项目编码
     */
    @NotBlank
    private String code;

    private CardGroupTask cardGroupTask;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CardGroupTask implements Serializable {

        private String code;
        private String name;
        private boolean enabled;
        private boolean isDefault;
        private Map<String, Map<String, String>> lang;

    }
}
