package com.digiwin.athena.datamap.povo;

import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-05-13 14:22
 **/
@Data
public class DataRequest {

    /**
     * 租户id
     */
    private String tenantId;
    private String dataMapId;
    /**
     * 项目code
     */
    private String projectCode;
    /**
     * 数据描述code
     */
    private String dataCode;
    /**
     * 数据状态起始code
     */
    private String fromStateCode;
    /**
     * 数据状态终点code
     */
    private String toStateCode;
    /**
     * 标签集合
     */
    private Map<String, String> tags = new HashMap<>();
    /**
     * 已完成状态集合
     */
    private List<String> doneStates = new ArrayList<>();
    /**
     * 是否检查
     */
    private Boolean checked;
    /**
     * 特征集合
     */
    private List<String> dateFeatures = new ArrayList<>();
    /**
     * 排除状态code集合
     */
    private List<String> excludeStateCodes = new ArrayList<>();

    /**
     * 运营单元信息
     */
    private Map<String, Object> eocInfo = new HashMap<>();
    /**
     * 查询主体code
     */
    private String code;
    /**
     * 事件id
     */
    private String eventId;

}
