package com.digiwin.athena.datamap.povo;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.datamap.enums.SourceType;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 系统级的条件配置
 */
public class SystemWSConditionVO implements Serializable {

    /**
     * 任务，排序
     */
    public static final List<WSConditionVO> taskOrderWSConditionVO = Collections.unmodifiableList(Arrays.asList(
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("阅读状态").aliasCode("READ_STATUS").dataType("boolean").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "閱讀狀態").put("en_US", "Reading status").put("zh_CN", "阅读状态").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("任务类型").aliasCode("TASK_TYPE").dataType("string").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "任務類型").put("en_US", "taskType").put("zh_CN", "任务类型").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("完成时间").aliasCode("FINISH_TIME").dataType("datetime").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "完成時間").put("en_US", "completion time").put("zh_CN", "完成时间").build()).build()).build()));
    /**
     * 任务，筛选
     */
    public static final List<WSConditionVO> taskFilterWSConditionVO = Collections.unmodifiableList(Arrays.asList(
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("任务类型").aliasCode("type").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "任務類型").put("en_US", "taskType").put("zh_CN", "任务类型").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("阅读状态").aliasCode("readStatus").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "閱讀狀態").put("en_US", "Reading status").put("zh_CN", "阅读状态").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("任务状态").aliasCode("status").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "任務狀態").put("en_US", "taskProgressStatus").put("zh_CN", "任务状态").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("任务来源").aliasCode("otherTaskInfo").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "任務來源").put("en_US", "Task source").put("zh_CN", "任务来源").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("完成时间").aliasCode("dateRange").dataType("date").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "完成時間").put("en_US", "completion time").put("zh_CN", "完成时间").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("团队成员").aliasCode("person").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "團隊成員").put("en_US", "Team Members").put("zh_CN", "团队成员").build()).build()).build()));
    /**
     * 任务，分组
     */
    public static final List<WSConditionVO> taskGroupWSConditionVO = Collections.unmodifiableList(Arrays.asList(
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("成员").aliasCode("groupByMember").enable(true).commonEnable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "成員").put("en_US", "member").put("zh_CN", "成员").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("部门").aliasCode("groupByDepartment").enable(true).commonEnable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "部門").put("en_US", "department").put("zh_CN", "部门").build()).build()).build()));
    /**
     * 项目，排序
     */
    public static final List<WSConditionVO> projectOrderWSConditionVO = Arrays.asList(
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("项目名称").aliasCode("NAME").dataType("string").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "項目名稱").put("en_US", "Project name").put("zh_CN", "项目名称").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("阅读状态").aliasCode("READ_STATUS").dataType("boolean").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "閱讀狀態").put("en_US", "Reading status").put("zh_CN", "阅读状态").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("异常/逾期状态").aliasCode("OVERDUE_EXCEPTION").dataType("boolean").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "異常/逾時狀態").put("en_US", "Abnormal/timeout status").put("zh_CN", "异常/逾时状态").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("项目时间").aliasCode("TIME").dataType("datetime").pointInTime(Arrays.asList(PointInTime.begin, PointInTime.end)).enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "項目時間").put("en_US", "Project time").put("zh_CN", "项目时间").build()).build()).build());
    /**
     * 项目，筛选
     */
    public static final List<WSConditionVO> projectFilterWSConditionVO = Collections.unmodifiableList(Arrays.asList(
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("项目类型").aliasCode("type").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "項目類型").put("en_US", "project type").put("zh_CN", "项目类型").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("阅读状态").aliasCode("readStatus").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "閱讀狀態").put("en_US", "Reading status").put("zh_CN", "阅读状态").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("项目状态").aliasCode("status").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "項目狀態").put("en_US", "Project Status").put("zh_CN", "项目状态").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("任务进行状态").aliasCode("process").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "任務進行狀態").put("en_US", "taskStatus").put("zh_CN", "任务进行状态").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("项目时距").aliasCode("dateRange").dataType("date").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "項目時距").put("en_US", "project time").put("zh_CN", "项目时距").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("团队成员").aliasCode("person").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "團隊成員").put("en_US", "Team members").put("zh_CN", "团队成员").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("项目来源").aliasCode("otherTaskInfo").dataType("select").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "項目來源").put("en_US", "Project source").put("zh_CN", "项目来源").build()).build()).build()));
    /**
     * 项目，分组
     */
    public static final List<WSConditionVO> projectGroupWSConditionVO = Collections.unmodifiableList(Arrays.asList(
            WSConditionVO.builder().sourceType(SourceType.system).enable(true).aliasName("不分组").aliasCode("noGrouping")
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "不分組").put("en_US", "noGrouping").put("zh_CN", "不分组").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).enable(true).aliasName("项目类型").aliasCode("groupByProjectType").dataType("STRING").defaultGroup(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "項目類型").put("en_US", "project type").put("zh_CN", "项目类型").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).enable(true).aliasName("项目时间").aliasCode("groupByProjectTime").dataType("DATETIME ")
                    .pointInTime(Arrays.asList(PointInTime.begin, PointInTime.end)).dimensionality(Arrays.asList(Dimensionality.month, Dimensionality.year))
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "項目時間").put("en_US", "Project time").put("zh_CN", "项目时间").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("成员").aliasCode("groupByMember").dataType("STRING").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "成員").put("en_US", "member").put("zh_CN", "成员").build()).build()).build(),
            WSConditionVO.builder().sourceType(SourceType.system).aliasName("部门").aliasCode("groupByDepartment").dataType("STRING").enable(true)
                    .lang(MapUtil.builder("aliasName", MapUtil.builder("zh_TW", "部門").put("en_US", "department").put("zh_CN", "部门").build()).build()).build()));

}
