package com.digiwin.athena.datamap.povo;

import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class ViewRequest {

    /**
     * 项目code
     */
    private String projectCode;
    /**
     * 任务code
     */
    private String taskCode;
    /**
     * page页面code
     */
    private String pageCode;
    /**
     * 查询条件
     */
    private Map<String, Object> query = new HashMap<>();
    /**
     * 邮箱模板code
     */
    private String emailTemplateCode;
    /**
     * 邮箱code
     */
    private String emailCode;
    /**
     * 多语言
     */
    private String locale;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 应用code
     */
    private String application;
    /**
     * 应用code
     */
    private String appCode;
    /**
     * 查询条件主体code
     */
    private String code;
    /**
     * 查询主体类型
     */
    private String type;
    /**
     * 任务code集合
     */
    private List<String> taskCodes;
    /**
     * 页面code列表
     */
    private List<String> pageCodes;

    /**
     * 运营单元信息
     */
    private Map<String, Object> eocInfo = new HashMap<>();

    /**
     * 自定义返回字段
     */
    private List<String> fields;
}
