package com.digiwin.athena.datamap.povo;

import com.digiwin.athena.datamap.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.datamap.enums.SourceType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 交付设计器的待办工作台设置中的条件
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WSConditionDTO implements Serializable {

    private String appCode;

    private String taskCode;

    private String taskName;

    /**
     * 此条件对应任务的多语系
     */
    public Map<String, Map<String, String>> taskLang;

    private BusinessMessageSourceMethod businessMessageSourceMethod;

    /**
     * pageview的createDate，用来排序
     */
    private Long createDate;

    /**
     * 名称
     */
    @NotBlank
    private String aliasName;
    /**
     * 代号
     */
    @NotBlank
    private String aliasCode;
    /**
     * 类型
     */
    @NotBlank
    private String dataType;

    /**
     * 是否默认启用
     */
    private Boolean defaultEffective;

    private SourceType sourceType;

    /**
     * 是否启用
     */
    private Boolean enable;

    /**
     * 分组下，是否默认分组项
     */
    private Boolean defaultGroup;

    /**
     * 交付设计器界面拖拽排序
     */
    private Integer sort;

    /**
     * 生效范围
     */
    private List<ConditionScopeDTO> conditionScope;

    public Map<String, Map<String, String>> lang;
}
