package com.digiwin.athena.datamap.povo.monitorrule;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.povo.monitorrule.ActionParamConfigDO;
import com.digiwin.athena.datamap.povo.monitorrule.ActionParamDTO;
import com.digiwin.athena.datamap.povo.monitorrule.ActionParamTypeEnum;

public class ColumnActionParamDTO extends ActionParamDTO {

    private String value;

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static ColumnActionParamDTO parseFromDO(ActionParamConfigDO configDO) throws DWBusinessException {
        if (configDO.getType() != ActionParamTypeEnum.COLUMN &&
                configDO.getType() != ActionParamTypeEnum.CONSTANT) {
            throw new DWBusinessException("Cannot parse from config to ColumnActionParam");
        }
        ColumnActionParamDTO paramDTO = new ColumnActionParamDTO();
        paramDTO.setName(configDO.getName());
        paramDTO.setValue(configDO.getValue());
        paramDTO.setType(configDO.getType());
        return paramDTO;
    }
}
