package com.digiwin.athena.datamap.povo.rebuild;

import com.digiwin.athena.domain.component.bo.ComponentBO;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.util.List;

/**
 * 因为在km_service的ComponentRead等类中重写了序列化行为，这里为了极致的性能优化重写了bo类，绕开序列化行为
 */
@Data
public class TenantAppComponentListBO2 {

    @Id
    private String uid;

    //应用编号，同时也是管理议题编号
    private String appCode;
    //租户id
    private String tenantId;
    //组件清单
    List<ComponentBO2> components;
}
