package com.digiwin.athena.datamap.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.dao.DataMapActivityDAO;
import com.digiwin.athena.datamap.povo.TenantABIReportDAO;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.spi.DatamapCacService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.TenantAppRelation;
import com.digiwin.athena.kg.authority.AuthorizedUser;
import com.digiwin.athena.kg.authority.AuthorizedUserResult;
import com.digiwin.athena.kg.report.dao.ABIReportUserStatistics;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DataMapReportManager {

    private final String USER_PERMISSION_TARGET_PREFIX = "drn:iam:app:";

    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private DataMapIamService dataMapIamService;
    @Autowired
    private DatamapCacService datamapCacService;
    @Autowired
    Executor executor;
    @Autowired
    DataMapKgDataPickService dataPickService;
    @Autowired
    private DatamapAppService datamapAppService;
    @Autowired
    KmService kmService;
    @Autowired
    private DataMapActivityDAO dataMapActivityDAO;


    private List<TenantABIReportDAO> allABiReport() throws DWBusinessException {
        List<String> codes = dataMapActivityDAO.getAllABiReportCodes();
        List<ApplicationRelation> relations = dataPickService.applicationRelations("activity",codes);
        List<String> appCodes = relations.stream().map(ApplicationRelation::getAppCode).distinct().collect(Collectors.toList());
        List<TenantAppRelation> tenantAppRelationByAppCode = kmService.getTenantAppRelationByAppCode(appCodes);
        Map<String,List<String>> appTenants = tenantAppRelationByAppCode.stream().collect(Collectors.toMap(TenantAppRelation::getAppCode,obj->{
            List<String> list = new ArrayList<>();
            list.add(obj.getTenantId());
            return list;
        },(List<String> list1,List<String> list2)->{
            list1.addAll(list2);
            return list1;
        }));

        List<TenantABIReportDAO> list = new ArrayList<>();

        for(ApplicationRelation applicationRelation:relations){
            List<String> tenants = appTenants.get(applicationRelation.getAppCode());
            if (CollectionUtils.isEmpty(tenants)) {
                continue;
            }
            for(String tenantId:tenants){
                TenantABIReportDAO dao = new TenantABIReportDAO();
                dao.setCode(applicationRelation.getCode());
                dao.setNamespace(applicationRelation.getAppCode());
                dao.setAthenaNamespace(applicationRelation.getAthena_namespace());
                dao.setTenantId(tenantId);
                dao.setTenantName(tenantId);
                list.add(dao);
            }
        }

        return list;
    }

    public Object getABIReportUserStatistics(String startDate, String endDate) throws DWBusinessException {
        List<ABIReportUserStatistics> result = new ArrayList<>();
       // List<TenantABIReportDAO> allABiReport = activity2Repository.getAllABiReport();
        List<TenantABIReportDAO> allABiReport = allABiReport();
        if(CollectionUtils.isEmpty(allABiReport)){
            return result;
        }
        Map<String, List<TenantABIReportDAO>> collectByTenant = allABiReport.stream().collect(Collectors.toMap(TenantABIReportDAO::getTenantId, p -> {
            List<TenantABIReportDAO> list = new ArrayList<>();
            list.add(p);
            return list;
        }, (List<TenantABIReportDAO> list1, List<TenantABIReportDAO> list2) -> {
            list1.addAll(list2);
            return list1;
        }));

        CountDownLatch countDownLatch = new CountDownLatch(collectByTenant.size());

        List<Application> applications = datamapAppService.postAllApplications();
        Map<String, Application> nameSpaceAppMap = applications.stream().collect(Collectors.toMap(Application::getCode, Function.identity(), (a,b)->a));

        Set<Map.Entry<String, List<TenantABIReportDAO>>> entries = collectByTenant.entrySet();
        for(Map.Entry<String, List<TenantABIReportDAO>> entry : entries){
            executor.execute(()->{
                try {
            String tenantId = entry.getKey();
            List<TenantABIReportDAO> value = entry.getValue();
            final Map<String, List<TenantABIReportDAO>> collectByApp = value.stream().collect(Collectors.toMap(e -> this.getAppGroupKey(e, nameSpaceAppMap), p -> {
                List<TenantABIReportDAO> list = new ArrayList<>();
                list.add(p);
                return list;
            }, (List<TenantABIReportDAO> list1, List<TenantABIReportDAO> list2) -> {
                list1.addAll(list2);
                return list1;
            }));


                log.info("==========ABIReportUserStatistics start tenant:{}", tenantId);
                //查看下Athena应用的生效时间
                Map<String, Map> allAppAuthorizationsMap = this.userAllAppAuthorizations(tenantId);
                Map athenaInfoMap = allAppAuthorizationsMap.get("Athena");
                if(athenaInfoMap == null){
//                    continue;
                    return;
                }
                String effectiveTime = String.valueOf(athenaInfoMap.get("effectiveTime"));
                String expiredTime = String.valueOf(athenaInfoMap.get("expiredTime"));

                if(!this.checkIsEffective(startDate, endDate, effectiveTime, expiredTime)){
//                    continue;
                    return;
                }

                String tenantToken = this.dataMapIamService.getTenantToken(tenantId);
                String tenantName = null;
                //被Athena应用授权的用户信息
                //能登陆athena不是看Athena这边这个已授权用户，而是看各个绑定Athena应用下的授权用户有哪些
//                List<AuthorizedUserResult> athenaAuthorizedUserList = this.iamService.getAuthorizedUser(tenantToken, "Athena");
//                if(CollectionUtils.isEmpty(athenaAuthorizedUserList)){
//                    continue;
//                }
//                //排除鼎捷内部用户
//                Map<String, AuthorizedUser> athenaAuthorizedUserMap = new HashMap<>();
//                for(AuthorizedUserResult authorizedUserResult : athenaAuthorizedUserList){
//                    String userId = authorizedUserResult.getUser().getId();
//                    if(userId.endsWith("digiwin.com")){
//                        continue;
//                    }
//                    athenaAuthorizedUserMap.put(userId, authorizedUserResult.getUser());
//                }
//                if(ObjectUtils.isEmpty(athenaAuthorizedUserMap)){
//                    continue;
//                }

                Map<String, List<Map<String, String>>> userTimeRangeTmp = new HashMap<>();
                Map<String, AuthorizedUserResult> userInfoMap = new HashMap<>();
                //记录已经查询好的用户的id（依据授权的应用的时间能覆盖查询的区间）
                Set<String> hasSetUserList = new HashSet<>();
                //遍历有ABI报表的应用
                Set<Map.Entry<String, List<TenantABIReportDAO>>> groupByAppEntries = collectByApp.entrySet();
                for(Map.Entry<String, List<TenantABIReportDAO>> entry1 : groupByAppEntries){
                    String appCode = entry1.getKey();
                    Map otherAppInfoMap = allAppAuthorizationsMap.get(appCode);
                    if(otherAppInfoMap == null){
                        continue;
                    }
                    String otherAppEffectiveTime = String.valueOf(otherAppInfoMap.get("effectiveTime"));
                    String otherAppExpiredTime = String.valueOf(otherAppInfoMap.get("expiredTime"));
                    //检查应用的有效期是否和查询的时间区间有重叠
                    if(!this.checkIsEffective(startDate, endDate, otherAppEffectiveTime, otherAppExpiredTime)){
                        continue;
                    }

                    List<AuthorizedUserResult> appAuthorizedUserList = this.dataMapIamService.getAuthorizedUser(tenantToken, appCode);
                    if(CollectionUtils.isEmpty(appAuthorizedUserList)){
                        continue;
                    }

                    List<TenantABIReportDAO> abiReportList = entry1.getValue();
                    for(AuthorizedUserResult authorizedUserResult : appAuthorizedUserList){
                        AuthorizedUser user = authorizedUserResult.getUser();
                         if(user.getId().endsWith("digiwin.com")){ //排除鼎捷用户
                            continue;
                        }
                        userInfoMap.put(user.getId(), authorizedUserResult);
                        if(hasSetUserList.contains(user.getId())){
                            continue;
                        }
                        //是否有Athena系统报表的入口权限
                        if(!this.hasPermission("Athena", user.getId(), tenantToken, "report:module-enable", null)){
                            continue;
                        }
                        //是否含有应用下具体报表的权限
                        if(!this.checkUserHasReportPermission(abiReportList, appCode, user.getId(), tenantToken)){
                            continue;
                        }

                        List<Map<String, String>> tmpTimeRangList = userTimeRangeTmp.get(user.getId());
                        if(CollectionUtils.isEmpty(tmpTimeRangList)){
                            tmpTimeRangList = new ArrayList<>();
                            userTimeRangeTmp.put(user.getId(), tmpTimeRangList);
                        }
                        Map<String, String> checkTimeRangeSuitableThenGet = this.checkTimeRangeSuitableThenGet(tmpTimeRangList,
                                startDate, endDate, otherAppEffectiveTime, otherAppExpiredTime);
                        if(checkTimeRangeSuitableThenGet != null){
                            hasSetUserList.add(user.getId());
                            userTimeRangeTmp.remove(user.getId());
                            tenantName = abiReportList.get(0).getTenantName();
                            ABIReportUserStatistics abiReportUserStatistics = new ABIReportUserStatistics();
                            abiReportUserStatistics.setTenantId(tenantId);
                            abiReportUserStatistics.setTenantName(StringUtils.isNotEmpty(tenantName) ? tenantName : tenantId);
                            abiReportUserStatistics.setUserId(user.getId());
                            abiReportUserStatistics.setUserName(user.getName());
                            abiReportUserStatistics.setOpeningStartDate(checkTimeRangeSuitableThenGet.get("effectiveTime").substring(0,10));
                            abiReportUserStatistics.setOpeningCloseDate(checkTimeRangeSuitableThenGet.get("expiredTime").substring(0,10));
                            abiReportUserStatistics.setProportion(this.calculateProportion(startDate, endDate,
                                    abiReportUserStatistics.getOpeningStartDate(), abiReportUserStatistics.getOpeningCloseDate()));
                            result.add(abiReportUserStatistics);
                        }

                    }

                }

                if(!ObjectUtils.isEmpty(userTimeRangeTmp)){
                    Set<Map.Entry<String, List<Map<String, String>>>> userTimeRangeEntrys = userTimeRangeTmp.entrySet();
                    for(Map.Entry<String, List<Map<String, String>>> userTimeRangeEntry : userTimeRangeEntrys){
                        String key = userTimeRangeEntry.getKey();
                        List<Map<String, String>> value1 = userTimeRangeEntry.getValue();
                        if(CollectionUtils.isNotEmpty(value1)){
                            for(Map<String, String> map : value1){
                                ABIReportUserStatistics abiReportUserStatistics = new ABIReportUserStatistics();
                                abiReportUserStatistics.setTenantId(tenantId);
                                abiReportUserStatistics.setTenantName(StringUtils.isNotEmpty(tenantName) ? tenantName : tenantId);
                                abiReportUserStatistics.setUserId(key);
                                abiReportUserStatistics.setUserName(userInfoMap.get(key).getUser().getName());
                                abiReportUserStatistics.setOpeningStartDate(map.get("effectiveTime").substring(0,10));
                                abiReportUserStatistics.setOpeningCloseDate(map.get("expiredTime").substring(0,10));
                                abiReportUserStatistics.setProportion(this.calculateProportion(startDate, endDate,
                                        abiReportUserStatistics.getOpeningStartDate(), abiReportUserStatistics.getOpeningCloseDate()));
                                result.add(abiReportUserStatistics);
                            }
                        }
                    }
                }


            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        } catch (InterruptedException e) {
            log.error("getABIReportUserStatistics error:{}", e);
            Thread.currentThread().interrupt();
        }
        return result;
    }


    private Map<String, String> checkTimeRangeSuitableThenGet(List<Map<String, String>> tmpTimeRangList, String startDate, String endDate, String newEffectiveTime, String newExpiredTime){
        //先比较最新应用的生效失效时间是否覆盖查询的区间
        if(this.isTimeSuitable(startDate,endDate,newEffectiveTime,newExpiredTime)){
            Map<String, String> map = new HashMap<>();
            map.put("effectiveTime", newEffectiveTime );
            map.put("expiredTime", newExpiredTime );
            return map;
        }else{
            //如果不能覆盖, 再把之前暂存的生效失效时间与最新的做合并，并与查询区间比较
            this.mergedTimeRange(tmpTimeRangList, newEffectiveTime, newExpiredTime);
            if(tmpTimeRangList != null && tmpTimeRangList.size() == 1){  //当tmp只有一个日期的时候,需验证下是否覆盖，多个的时候一定是有间隔的
                Map<String, String> stringStringMap = tmpTimeRangList.get(0);
                String effectiveTime = stringStringMap.get("effectiveTime");
                String expiredTime = stringStringMap.get("expiredTime");
                if(this.isTimeSuitable(startDate,endDate,effectiveTime,expiredTime)){
                    return stringStringMap;
                }
            }
        }
        //还是不能覆盖，暂存，并返回null
        return null;
    }

    private void mergedTimeRange(List<Map<String, String>> tmpTimeRangList, String newEffectiveTime, String newExpiredTime){
        if(CollectionUtils.isEmpty(tmpTimeRangList)){
            Map<String, String> map = new HashMap<>();
            map.put("effectiveTime", newEffectiveTime );
            map.put("expiredTime", newExpiredTime );
            tmpTimeRangList.add(map);
        }else{
            boolean mergeFlag = false;
            Iterator<Map<String, String>> iterator = tmpTimeRangList.iterator();
            while(iterator.hasNext()){
                Map<String, String> next = iterator.next();
                if(this.checkTimeCanMerge(next.get("effectiveTime"), next.get("expiredTime"), newEffectiveTime, newExpiredTime)){
                    //区间有交集
                    newEffectiveTime = this.getEarlyEffectiveTime(next.get("effectiveTime"), newEffectiveTime);
                    newExpiredTime = this.getLateExpireTime(next.get("expiredTime"), newExpiredTime);
                    iterator.remove();
                    mergeFlag = true;
                    break;
                }
            }
            if(mergeFlag){
                mergedTimeRange(tmpTimeRangList, newEffectiveTime, newExpiredTime);
            }else{
                Map<String, String> map = new HashMap<>();
                map.put("effectiveTime", newEffectiveTime );
                map.put("expiredTime", newExpiredTime );
                tmpTimeRangList.add(map);
            }
        }

    }

    private boolean checkTimeCanMerge(String startDate, String endDate, String effectiveTime, String expiredTime){
        LocalDate startLocalDate = LocalDate.parse(startDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate effectiveLocalDate = LocalDate.parse(effectiveTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate expiredLocalDate = LocalDate.parse(expiredTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));

        return (startLocalDate.compareTo(expiredLocalDate) < 0 && endLocalDate.compareTo(effectiveLocalDate) > 0)
                || (startLocalDate.isEqual(expiredLocalDate) || startLocalDate.minusDays(1).equals(effectiveLocalDate))
                || (endLocalDate.isEqual(effectiveLocalDate) || endLocalDate.plusDays(1).equals(effectiveLocalDate));
    }

    private String getEarlyEffectiveTime(String effectiveTime1, String effectiveTime2){
        LocalDate startLocalDate = LocalDate.parse(effectiveTime1.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(effectiveTime2.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        if(startLocalDate.isBefore(endLocalDate)){
            return effectiveTime1.substring(0, 10);
        }else{
            return effectiveTime2.substring(0, 10);
        }
    }

    private String getLateExpireTime(String effectiveTime1, String effectiveTime2){
        LocalDate startLocalDate = LocalDate.parse(effectiveTime1.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(effectiveTime2.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        if(startLocalDate.isBefore(endLocalDate)){
            return effectiveTime2.substring(0, 10);
        }else{
            return effectiveTime1.substring(0, 10);
        }
    }

    private long localDateCompare(LocalDate startDate, LocalDate endDate){
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    private String calculateProportion(String startDate, String endDate, String appStart, String appEnd){
        LocalDate startLocalDate = LocalDate.parse(startDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate effectiveLocalDate = LocalDate.parse(appStart.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate expiredLocalDate = LocalDate.parse(appEnd.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        if(effectiveLocalDate.compareTo(startLocalDate) <= 0 && expiredLocalDate.compareTo(endLocalDate) >= 0){
             return "1";
        }else if(effectiveLocalDate.compareTo(startLocalDate) < 0){
            long totalDay = localDateCompare(startLocalDate, endLocalDate);
            long useDay = localDateCompare(startLocalDate, expiredLocalDate);
            return this.calculateProportion(totalDay, useDay);
        }else{
            long totalDay = localDateCompare(startLocalDate, endLocalDate);
            long useDay = localDateCompare(effectiveLocalDate, endLocalDate);
            return this.calculateProportion(totalDay, useDay);
        }

    }

    private String calculateProportion(long totalDay, long useDay){
        BigDecimal totalbigDecimal = new BigDecimal(String.valueOf(totalDay));
        BigDecimal usebigDecimal = new BigDecimal(String.valueOf(useDay));
        return usebigDecimal.divide(totalbigDecimal, 2, BigDecimal.ROUND_HALF_UP).toString();
    }


    private boolean isTimeSuitable(String startDate, String endDate, String effectiveTime, String expiredTime){
        LocalDate startLocalDate = LocalDate.parse(startDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate effectiveLocalDate = LocalDate.parse(effectiveTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate expiredLocalDate = LocalDate.parse(expiredTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));

        return startLocalDate.compareTo(effectiveLocalDate) >= 0 && endLocalDate.compareTo(expiredLocalDate) <= 0;
    }

    public static void main(String[] args) {
//        System.out.println(new ReportManager().isTimeSuitable("2022-01-02", "2022-02-01","2022-01-03 00:00:00", "2022-02-02"));
        List<Map<String, String>> list = new ArrayList<>();
        Map<String, String> map = new HashMap<>();
        map.put("effectiveTime", "2022-01-02" );
        map.put("expiredTime", "2022-02-01" );

        Map<String, String> map1 = new HashMap<>();
        map1.put("effectiveTime", "2022-05-03" );
        map1.put("expiredTime", "2022-06-03" );

        list.add(map);
        list.add(map1);


        new DataMapReportManager().mergedTimeRange(list, "2022-03-04", "2022-05-03");
        System.out.println(list);
    }


    private boolean checkUserHasReportPermission(List<TenantABIReportDAO> abiReportList, String appCode, String userId, String token){
        Object allUserPermission = this.dataMapIamService.getUserPermission(appCode, userId, token);
        for(TenantABIReportDAO tenantABIReportDAO : abiReportList){
            //找到一个就返回true
            if(this.hasPermission(appCode, userId, token, "report:" + tenantABIReportDAO.getCode(), "enable", allUserPermission)){
                return true;
            }
        }
        return  false;
    }


    private String getAppGroupKey(TenantABIReportDAO tenantABIReportDAO, Map<String, Application> nameSpaceAppMap){
        if(StringUtils.isNotEmpty(tenantABIReportDAO.getAthenaNamespace()) ){
            return tenantABIReportDAO.getAthenaNamespace();
        }else{
            Application appEntity = nameSpaceAppMap.get(tenantABIReportDAO.getNamespace());
            if(appEntity != null){
                return appEntity.getCode();
            }
            return tenantABIReportDAO.getNamespace();
        }
    }

    private Map<String, Map> userAllAppAuthorizations(String tenantId){
        Map<String, Map> result = new HashMap<>();
        Object obj = this.datamapCacService.authorizationsTenants(tenantId);
        if( obj == null){
            return result;
        }
        JSONArray jsonArray = JSON.parseArray(JSONObject.toJSONString(obj));
        for(int i = 0 ; i < jsonArray.size(); i++){
            String code = jsonArray.getJSONObject(i).getString("code");
            if(!result.containsKey(code)){
                result.put(code, jsonArray.getJSONObject(i));
            }
        }
        return result;
    }

    private boolean checkIsEffective(String startDate, String endDate, String effectiveTime, String expiredTime){
        LocalDate startLocalDate = LocalDate.parse(startDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endLocalDate = LocalDate.parse(endDate.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate effectiveLocalDate = LocalDate.parse(effectiveTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate expiredLocalDate = LocalDate.parse(expiredTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        //查询的开始时间小于应用结束时间 并且 查询的查询的结束时间大于应用的开始时间
        return startLocalDate.compareTo(expiredLocalDate) < 0 && endLocalDate.compareTo(effectiveLocalDate) > 0;
    }

    private boolean hasPermission(String appCode, String userId, String token, String target, String conditionKey){
        Object allUserPermission = this.dataMapIamService.getUserPermission(appCode, userId, token);
        return this.hasPermission(appCode,userId,token,target,conditionKey,allUserPermission);
    }

    private boolean hasPermission(String appCode, String userId, String token, String target, String conditionKey, Object allUserPermission){
        JSONObject responseJson = JSONObject.parseObject(JSON.toJSONString(allUserPermission));
        String code = responseJson.getString("code");
        if(!"200".equals(code)){  //查询权限异常，则无权限
            return false;
        }
        JSONArray permissions = responseJson.getJSONArray("data");
        if(permissions == null){
            return true;
        }

        for(int i=0; i<permissions.size(); i++) {
            JSONObject permissionJson = permissions.getJSONObject(i);
            JSONObject conditions = permissionJson.getJSONObject("conditions");
            String dbTarget = permissionJson.getString("target");
            if (StringUtils.equals(dbTarget, USER_PERMISSION_TARGET_PREFIX + appCode + ":" + target)) {  //如果不是对应的模组，则跳过
                String effect = permissionJson.getString("effect");
                if(!StringUtils.equals("allow", effect)){
                    return false;
                }
                if(StringUtils.isNotEmpty(conditionKey)){
                    JSONObject moduleJsonObject = conditions.getJSONObject(USER_PERMISSION_TARGET_PREFIX + appCode + ":" + target);
                    if(moduleJsonObject == null){
                        continue;
                    }else{
                        String psermissionResult = moduleJsonObject.getString(conditionKey);
                        return StringUtils.equals("allow", psermissionResult);
                    }
                }

            }

        }
        return true;
    }


}
