package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRequestParam;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.dto.ActivityBaseInfoVO;

import java.util.List;
import java.util.Map;

/**
 * 活动服务类
 * @javadoc
 */
@DWRestfulService
public interface IActivityService extends DWService {

    /**
     * 保存活动定义信息
     * @param activity 需要保存的活动数据
     * @return 返回活动
     * @throws DWException
     */
    @DWRequestMapping(path = "/activity/saveActivity", method = {DWRequestMethod.POST})
    Object postSaveActivity(Activity activity);

    /**
     * 根据任务code获取任务输入流程变量
     * @param activityId 任务code
     * @return 任务输入流程变量
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/activity/inputData", method = {DWRequestMethod.GET})
    Map<String, Object> getInputData(@DWRequestParam String activityId) throws DWBusinessException;

    /**
     * 根据任务code获取任务输入流程变量(已废弃)
     * @param taskId 任务code
     * @param activityId 活动code
     * @return 任务输入流程变量
     * @Deprecated
     * @throws DWBusinessException
     */
    @Deprecated
    @DWRequestMapping(path = "/activity/inputData", method = {DWRequestMethod.GET})
    Map<String, Object> getInputData(@DWRequestParam String taskId, @DWRequestParam String activityId) throws DWBusinessException;

    /**
     * 根据项目code获取任务，并设置产品信息
     * @param taskCode 项目code
     * @param appCode 应用code
     * @param locale 语言
     * @param paramCodeAndValue 参数code以及对应值
     * @return 返回活动
     * @throws Exception
     */
    @DWRequestMapping(path = "/activity/activityByTask", method = {DWRequestMethod.POST})
    List<ActivityBaseInfoVO> postActivityByTask(String taskCode, String appCode, String locale, Map<String, Object> paramCodeAndValue) throws Exception;

    /**
     * 根据应用code获取签核任务
     * @param applicationCode 应用code
     * @param locale 语言
     * @return 任务
     * @throws DWException
     */
    @DWRequestMapping(path = "/activity/allApproveActivityByApp", method = {DWRequestMethod.GET})
    List<ActivityBaseInfoVO> getAllApproveActivityByApp(@DWRequestParam String applicationCode, @DWRequestParam String locale) throws DWException;






}
