package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.BatchRequest;
import com.digiwin.athena.datamap.povo.CommonReq;
import com.digiwin.athena.datamap.povo.CommonResp;
import com.digiwin.athena.datamap.povo.MongoCrudReq;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;

import java.util.List;
import java.util.Map;

/**
 * 批量查询服务
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-01-13 11:10
 * @javadoc
 **/
@DWRestfulService
public interface IBatchService extends DWService {

    /**
     * 批量获取项目基本信息
     * @param q 查询参数
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/batch/projectBasic", method = {DWRequestMethod.POST})
    List<Project> postProjectBasic(BatchRequest q) throws DWBusinessException;

    /**
     * 批量获取任务基本信息
     * @param q 查询参数
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/batch/taskBasic", method = {DWRequestMethod.POST})
    List<Task> postTaskBasic(BatchRequest q) throws DWBusinessException;

    /**
     * 批量获取项目详情
     * @param q 查询参数
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/batch/projects", method = {DWRequestMethod.POST})
    CommonResp postProjects(CommonReq q) throws DWBusinessException;

    /**
     * 批量获取任务详情
     * @param q 查询参数
     *
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/batch/tasks", method = {DWRequestMethod.POST})
    CommonResp postTasks(CommonReq q) throws DWBusinessException;

    /**
     * 批量执行mongo crud操作
     * @param q 参数
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/batch/mongo", method = {DWRequestMethod.POST})
    CommonResp postMongo(MongoCrudReq q);

    /**
     * 批量获取任务详情
     * @param q 查询参数
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/batch/taskDetails", method = {DWRequestMethod.POST})
    Map<String, Map<String, Object>> postTaskDetails(BatchRequest q) throws DWBusinessException;

    /**
     * 批量查询
     * @param codes
     * @param type
     * @param version
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/batch/queryCodeAndName", method = {DWRequestMethod.POST})
    CommonResp postQueryCodeAndName(List<String> codes, String type, String version);
}
