package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.domain.core.Project;

import java.util.List;

/**
 * 业务服务
 * @author xuhx
 * @date 2024/10/21
 * @javadoc
 */
@DWRestfulService
public interface IBusinessService extends DWService {

    /**
     * 根据应用 code 批量查询项目信息（排除手动发起项目）
     *
     * @param appCode
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/business/projectExcludeMainlineByAppCode", method = {DWRequestMethod.POST})
    List<Project> postProjectExcludeMainlineByAppCode(String appCode) throws DWBusinessException;

}
