package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;

/**
 * 职能服务
 * @javadoc
 */
@DWRestfulService
public interface IDutyService extends DWService {
    /**
     * 根据code获取职能信息
     * @param code 职能code
     * @return
     */
    @DWRequestMapping(path = "/duty/dutyByCode", method = {DWRequestMethod.GET})
    @AllowAnonymous
    Object getDutyByCode(String code);

    /**
     * 获取全量职能数据
     * @return
     */
    @DWRequestMapping(path = "/duty/list", method = {DWRequestMethod.GET})
    @AllowAnonymous
    Object getList();

    /**
     * 同步职能数据
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/duty/syncAllDuty", method = {DWRequestMethod.GET})
    Object syncAllDuty() throws DWBusinessException;

    /**
     * 根据应用code和租户id同步职能数据
     * @param token token校验码
     * @param appCode 应用code
     * @param tenantId 租户id
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/duty/syncAllDuty", method = {DWRequestMethod.GET})
    Object syncAllDuty(String token, String appCode, String tenantId) throws Exception;

    /**
     * 根据token同步职能数据
     * @param token token校验码
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/duty/syncAllDuty", method = {DWRequestMethod.GET})
    @AllowAnonymous
    Object syncAllDuty(String token) throws DWBusinessException;

    /**
     * 测试方法
     * @param p 参数
     * @return
     */
    @DWRequestMapping(path = "/duty/test", method = {DWRequestMethod.GET})
    @AllowAnonymous
    Object getTest(String p);

}
