package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.domain.erp.*;
import com.digiwin.athena.datamap.povo.ErpClean;
import java.util.List;

/**
 * ERP服务
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-01-13 11:10
 * @javadoc
 **/
@DWRestfulService
public interface IErpService extends DWService {

    /**
     * 同步ERP签核单
     * @param bill ERP签核单
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/erp/sync", method = {DWRequestMethod.POST})
    Object postSync(ErpSyncBill bill) throws DWException;

    /**
     * 更新页面视图
     * @param list
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/erp/updatePageView", method = {DWRequestMethod.POST})
    Object postUpdatePageView(List<String> list) throws DWException;

    @DWRequestMapping(path = "/erp/update", method = {DWRequestMethod.POST})
    Object postUpdate(ErpSyncRecord record) throws DWException;

    @DWRequestMapping(path = "/erp/records", method = {DWRequestMethod.GET})
    List getRecords() throws DWException;

    @DWRequestMapping(path = "/erp/record", method = {DWRequestMethod.GET})
    Object getRecord(String code) throws DWException;

    @DWRequestMapping(path = "/erp/clean", method = {DWRequestMethod.POST})
    Object postClean(ErpClean clean) throws DWException;

    @DWRequestMapping(path = "/erp/erp2FormInfo", method = {DWRequestMethod.GET})
    Erp2FormInfo getErp2FormInfo() throws DWException;

    @DWRequestMapping(path = "/erp/create", method = {DWRequestMethod.POST})
    Object postCreate(Erp2FormDTO dto) throws DWException;

    @DWRequestMapping(path = "/erp/projectByData", method = {DWRequestMethod.POST})

    Object postProjectByData(Erp2DataDTO dto) throws DWException;

    @AllowAnonymous
    @DWRequestMapping(path = "/erp/upgradeErp2", method = {DWRequestMethod.GET})
    Object getUpgradeErp2() throws DWException;

}
