package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.dto.BindingResult;
import com.digiwin.athena.dto.TaskPathVo;
import java.util.List;

/**
 * 插件服务
 * @javadoc
 */
@DWRestfulService
public interface IPluginService extends DWService {

    /**
     * 插件合并
     * @param binding 插件数据
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/plugin/merge", method = {DWRequestMethod.POST})
    BindingResult postMergePlugin(PluginBindingPo binding) throws DWException;

    /**
     * 移除插件
     * @param binding 移除插件
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/plugin/remove", method = {DWRequestMethod.POST})
    List<TaskPathVo> postRemovePlugin(PluginBindingPo binding) throws DWException;

}